/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ClientSocket;
import ca.nanometrics.msg.ConnectMessage;
import ca.nanometrics.msg.MsgConsumer;
import ca.nanometrics.msg.MsgProducer;
import ca.nanometrics.msg.RequestPending;
import ca.nanometrics.msg.StatusMonitor;
import ca.nanometrics.msg.TerminateMessage;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.LoopRunner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class MsgClient
extends LoopRunner
implements MsgProducer {
    private static final int PING_INTERVAL = 10;
    private static final int REPORT_INTERVAL = 10;
    private static final int MIN_RECONNECT_TIME = 2000;
    private static final int MAX_RECONNECT_TIME = 20000;
    private static final int LOOP_DELAY = 500;
    private InetAddress addr = null;
    protected ClientSocket sock;
    private int ticksTilPing = 10;
    private int ticksTilReport = 0;
    private int timeUntilReconnect = 0;
    private int nextSleepTime = 2000;
    StatusMonitor monitor = null;
    private Vector subscribers = new Vector();

    public MsgClient(String name) {
        super(name);
        this.sock = new ClientSocket(this.addr, 28000, false);
    }

    public MsgClient() {
        this("MsgClient");
    }

    public void setMonitor(StatusMonitor aMonitor) {
        this.monitor = aMonitor;
    }

    private void reportStatus(String status) {
        if (this.monitor != null) {
            this.monitor.reportStatus(status);
        }
    }

    public void connectTo(String host, int port, boolean callback) throws UnknownHostException {
        this.addr = host == null ? null : InetAddress.getByName(host);
        this.sock.setAddress(this.addr, port, callback);
        this.timeUntilReconnect = 2000;
        this.nextSleepTime = 2000;
    }

    public void disconnect() {
        this.addr = null;
        this.sock.setAddress(this.addr, 28000, false);
    }

    public void addSubscriber(MsgConsumer consumer) {
        if (consumer != null && !this.subscribers.contains(consumer)) {
            this.subscribers.addElement(consumer);
        }
    }

    public void removeSubscriber(MsgConsumer consumer) {
        this.subscribers.removeElement(consumer);
    }

    public boolean send(Packable pkt) {
        try {
            this.sock.send(pkt);
            return true;
        }
        catch (IOException ioe) {
            this.reportStatus("Send failed:" + ioe.getMessage());
            Log.report(this, 3, 3, "Send failed: " + ioe.getMessage());
            this.sock.close();
            return false;
        }
    }

    public boolean acceptRequest(Packable pkt) {
        return this.send(pkt);
    }

    protected void open() {
        Log.report(this, 0, 2, "MsgClient starting up ...");
    }

    protected void close() {
        Log.report(this, 1, 2, "closing thread.");
        this.send(new TerminateMessage(1));
        this.sock.close();
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean timeToReport() {
        if (--this.ticksTilReport <= 0) {
            this.ticksTilReport = 10;
            return true;
        }
        return false;
    }

    protected void tick() {
        Log.report(this, 9, 0, "tick()");
        if (this.sock.isConnected() && --this.ticksTilPing <= 0) {
            this.reportStatus("Connected to " + this.getAddressString());
            this.ticksTilPing = 10;
            this.send(new RequestPending());
        }
    }

    protected void processPacket(Packable pkt) {
    }

    private void distributePacket(Packable pkt) {
        Enumeration e = this.subscribers.elements();
        while (e.hasMoreElements()) {
            ((MsgConsumer)e.nextElement()).put(pkt);
        }
    }

    private void receive() {
        try {
            Packable pkt = this.sock.receive();
            if (pkt == null) {
                Log.report(this, 4, 3, "Received null packet");
            } else {
                this.processPacket(pkt);
                this.distributePacket(pkt);
            }
        }
        catch (InterruptedIOException pkt) {
        }
        catch (IOException ioe) {
            this.reportStatus("Receive failed: " + ioe.getMessage());
            Log.report(this, 5, 3, "Receive failed: " + ioe.getMessage());
            this.sock.close();
        }
    }

    public String getAddressString() {
        if (this.addr != null) {
            return String.valueOf(this.addr.getHostName()) + ":" + this.sock.getPort();
        }
        return "Host address not specified.";
    }

    private void maintainConnection() {
        block5: {
            if (this.timeUntilReconnect > 0) {
                if (this.timeToReport()) {
                    this.reportStatus("Reconnecting in " + this.timeUntilReconnect / 1000 + " seconds.");
                }
                this.timeUntilReconnect -= 500;
                this.sleep(500);
            } else {
                try {
                    this.reportStatus("Contacting " + this.getAddressString());
                    Log.report(this, 6, 0, "try to reconnect...");
                    this.sock.reconnect();
                    this.sock.send(new ConnectMessage());
                    this.timeUntilReconnect = 2000;
                    this.nextSleepTime = 2000;
                    this.reportStatus("Connected to " + this.getAddressString());
                    Log.report(this, 2, 2, "Connected to Naqs (" + this.getAddressString() + ")");
                }
                catch (IOException ioe) {
                    this.timeUntilReconnect = this.nextSleepTime;
                    this.ticksTilReport = 10;
                    this.reportStatus("Connect failed: " + ioe);
                    Log.report(this, 7, 2, "connect failed: " + ioe);
                    this.nextSleepTime *= 2;
                    if (this.nextSleepTime <= 20000) break block5;
                    this.nextSleepTime = 20000;
                }
            }
        }
    }

    protected final void body() {
        if (this.addr == null) {
            if (this.timeToReport()) {
                this.reportStatus("Not connected:  host address not specified");
            }
            this.sleep(500);
            return;
        }
        if (!this.sock.isConnected()) {
            this.maintainConnection();
        } else {
            this.receive();
        }
    }
}

