/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StringMessage {
    private byte[] msgBuffer;

    public StringMessage(String message) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeBytes(message);
            ds.writeByte(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.msgBuffer = bs.toByteArray();
    }

    public StringMessage(byte[] buffer, int offset, int length) {
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return this.msgBuffer.length;
    }

    public void writeTo(byte[] buffer, int offset) {
        System.arraycopy(this.msgBuffer, 0, buffer, offset, this.msgBuffer.length);
    }

    public void readFrom(byte[] buffer, int offset, int length) {
        this.msgBuffer = new byte[length];
        System.arraycopy(buffer, offset, this.msgBuffer, 0, length);
    }

    public String getMessage() {
        String s = new String(this.msgBuffer, 0, this.msgBuffer.length - 1);
        return s;
    }
}

