/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TerminateMessage
implements Packable {
    public static final int MSG_TYPE = 200;
    public static final int NORMAL_SHUTDOWN = 1;
    public static final int ERROR_SHUTDOWN = 2;
    public static final int TIMEOUT_SHUTDOWN = 3;
    public static final int INT_SIZE = 4;
    private int termType;
    private byte[] msgBuffer;

    public TerminateMessage(int termType, String message) {
        this.termType = termType;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeBytes(message);
            ds.writeByte(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.msgBuffer = bs.toByteArray();
    }

    public TerminateMessage(int termType) {
        this.termType = termType;
        this.msgBuffer = new byte[0];
    }

    public TerminateMessage(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 200;
    }

    public int getDataLength() {
        return 4 + this.msgBuffer.length;
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.termType);
        System.arraycopy(this.msgBuffer, 0, buffer, offset + 4, this.msgBuffer.length);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (buffer.length - offset < 4) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.termType = BigEndian.readInt(buffer, offset);
        this.msgBuffer = new byte[length - 4];
        System.arraycopy(buffer, offset + 4, this.msgBuffer, 0, length - 4);
    }

    public String getTermMessage() {
        if (this.msgBuffer.length > 0) {
            return new String(this.msgBuffer, 0, this.msgBuffer.length - 1);
        }
        return "";
    }

    public int getTermType() {
        return this.termType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TerminateMessage (");
        sb.append(this.termType);
        sb.append(")");
        String msg = this.getTermMessage();
        if (msg.length() > 0) {
            sb.append(" ");
            sb.append(msg);
        }
        return sb.toString();
    }
}

