/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelInfoRequest
implements Packable {
    public static final int MSG_TYPE = 226;
    public static final int INT_SIZE = 4;
    public static final int MSG_LEN = 8;
    public static final int REQUEST_INFO = 0;
    public static final int REQUEST_Y5HEADER = 1;
    public static final int REQUEST_RESPONSE = 2;
    private int key;
    private int type;

    public ChannelInfoRequest() {
        this(0, 0);
    }

    public ChannelInfoRequest(int channelKey, int requestType) {
        this.key = channelKey;
        this.type = requestType;
    }

    public ChannelInfoRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 226;
    }

    public int getDataLength() {
        return 8;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 8 || offset + 8 > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.key = BigEndian.readInt(buffer, offset);
        this.type = BigEndian.readInt(buffer, offset += 4);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeInt(buffer, offset += 4, this.type);
    }

    public int getKey() {
        return this.key;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.key + ", " + this.type + ")";
    }
}

