/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelPrecis {
    static final int NAME_LEN = 12;
    static final int INT_SIZE = 4;
    static final int MAX_LENGTH = 11;
    static final int ENTRY_SIZE = 24;
    private int key;
    private String name;
    private int startTime;
    private int endTime;

    public ChannelPrecis() {
        this(0, null, 0, 0);
    }

    public ChannelPrecis(int channelKey, String channelName, int startSec, int endSec) {
        this.key = channelKey;
        this.name = channelName;
        this.startTime = startSec;
        this.endTime = endSec;
        if (this.name == null) {
            this.name = "none";
        }
        if (this.name.length() > 11) {
            this.name = this.name.substring(0, 11);
        }
    }

    public int getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length >= 24 && offset + length <= buffer.length) {
            this.key = BigEndian.readInt(buffer, offset);
            this.name = BigEndian.readString(buffer, offset += 4, 12);
            this.startTime = BigEndian.readInt(buffer, offset += 12);
            this.endTime = BigEndian.readInt(buffer, offset += 4);
            offset += 4;
        } else {
            throw new InvalidInputException("readFrom: insufficient data");
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeString(buffer, offset += 4, this.name, 12);
        BigEndian.writeInt(buffer, offset += 12, this.startTime);
        BigEndian.writeInt(buffer, offset += 4, this.endTime);
        offset += 4;
    }

    public String toString() {
        return "(" + this.name + " " + this.key + ", " + this.startTime + ", " + this.endTime + ")";
    }
}

