/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ConnectResponse
implements Packable {
    public static final int MSG_TYPE = 207;
    public static final int INT_SIZE = 4;
    public static final int MSG_LEN = 4;
    private int protocolVersion;

    public ConnectResponse() {
        this(0);
    }

    public ConnectResponse(int availableVersion) {
        this.protocolVersion = availableVersion;
    }

    public ConnectResponse(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 207;
    }

    public int getDataLength() {
        return 4;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4 || offset + 4 > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.protocolVersion = BigEndian.readInt(buffer, offset);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.protocolVersion);
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.protocolVersion + ")";
    }
}

