/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class DataSize
implements Packable {
    public static final int MSG_TYPE = 257;
    public static final int INT_SIZE = 4;
    public static final int MSG_LEN = 12;
    private int key;
    private int packetLength;
    private int maxPacketCount;

    public DataSize() {
        this(0, 0, 0);
    }

    public DataSize(int channelKey, int pktLength, int numPackets) {
        this.key = channelKey;
        this.packetLength = pktLength;
        this.maxPacketCount = numPackets;
    }

    public DataSize(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 257;
    }

    public int getDataLength() {
        return 12;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 12 || offset + 12 > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.key = BigEndian.readInt(buffer, offset);
        this.packetLength = BigEndian.readInt(buffer, offset += 4);
        this.maxPacketCount = BigEndian.readInt(buffer, offset += 4);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        BigEndian.writeInt(buffer, offset += 4, this.packetLength);
        BigEndian.writeInt(buffer, offset += 4, this.maxPacketCount);
    }

    public int getKey() {
        return this.key;
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public int getMaxPacketCount() {
        return this.maxPacketCount;
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.key + ", " + this.packetLength + ", " + this.maxPacketCount + ")";
    }
}

