/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.nda.ChannelPrecis;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PrecisList
implements Packable {
    public static final int MSG_TYPE = 253;
    static final int INT_SIZE = 4;
    static final int MIN_REQUEST_SIZE = 4;
    private List channels = new LinkedList();

    public PrecisList() {
    }

    public PrecisList(ChannelPrecis[] entries) {
        this.add(entries);
    }

    public PrecisList(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public void add(ChannelPrecis entry) {
        if (entry != null) {
            this.channels.add(entry);
        }
    }

    public void add(ChannelPrecis[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            int ix = 0;
            while (ix < numEntries) {
                this.add(entries[ix]);
                ++ix;
            }
        }
    }

    public void add(int key, String name, int startTime, int endTime) {
        this.add(new ChannelPrecis(key, name, startTime, endTime));
    }

    public int getDataType() {
        return 253;
    }

    public int getDataLength() {
        return 4 + 24 * this.getChannelCount();
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        int last = offset + length;
        if (length >= 4 && last <= buffer.length) {
            int numChannels = BigEndian.readInt(buffer, offset);
            this.channels.clear();
            offset += 4;
            int ix = 0;
            while (ix < numChannels) {
                ChannelPrecis cp = new ChannelPrecis();
                cp.readFrom(buffer, offset, last - offset);
                this.add(cp);
                offset += 24;
                ++ix;
            }
        } else {
            throw new InvalidInputException("readFrom: insufficient data");
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.getChannelCount());
        offset += 4;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ChannelPrecis cp = (ChannelPrecis)iter.next();
            cp.writeTo(buffer, offset);
            offset += 24;
        }
    }

    public Iterator iterator() {
        return this.channels.iterator();
    }

    public int getChannelCount() {
        return this.channels.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().getName()) + " [");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

