/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.nda;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.yfile.Y5Header;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class Y5HeaderMsg
implements Packable {
    public static final int MSG_TYPE = 261;
    static final int INT_SIZE = 4;
    private int key;
    private Y5Header header;

    public Y5HeaderMsg(int channelKey, Y5Header channelHeader) {
        this.key = channelKey;
        this.header = channelHeader;
    }

    public Y5HeaderMsg() {
        this(0, new Y5Header());
    }

    public Y5HeaderMsg(byte[] buffer, int offset, int length) throws InvalidInputException {
        this();
        this.readFrom(buffer, offset, length);
    }

    public int getKey() {
        return this.key;
    }

    public Y5Header getY5Header() {
        return this.header;
    }

    public int getDataLength() {
        return 4 + this.header.getDataLength();
    }

    public int getDataType() {
        return 261;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4 || offset + length > buffer.length) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        try {
            this.key = BigEndian.readInt(buffer, offset);
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer, offset += 4, length -= 4);
            DataInputStream dis = new DataInputStream(bais);
            this.header.readHeader(dis);
        }
        catch (Exception any) {
            throw new InvalidInputException("readFrom: " + any.getMessage());
        }
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.key);
        byte[] headerBytes = this.header.toByteArray();
        System.arraycopy(headerBytes, 0, buffer, offset += 4, headerBytes.length);
    }

    public String toString() {
        String className = this.getClass().getName();
        return String.valueOf(className) + " (" + this.key + ")";
    }
}

