/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import ca.nanometrics.net.PersistentMulticastSocket;
import ca.nanometrics.packet.CalibrationResponse;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.PacketHandler;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.FileLog;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.LoopRunner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class CalibrationResponseReceiver
extends LoopRunner {
    static final int RX_BUFFER_SIZE = 512;
    private MulticastSocket ds = null;
    private PacketWrapper pw = new InternetPacketWrapper();
    private PacketHandler handler;

    public CalibrationResponseReceiver(int udpPortNum, String mCastAddr, PacketHandler pktHandler) throws IOException {
        this.handler = pktHandler;
        try {
            this.ds = new PersistentMulticastSocket(udpPortNum, 30000);
            this.ds.setSoTimeout(500);
            if (mCastAddr != null) {
                this.joinGroup(mCastAddr);
            }
        }
        catch (IOException ioe) {
            Log.report(this, 1, 5, "Cannot open datagram socket.");
            throw ioe;
        }
    }

    private void joinGroup(String mCastAddr) {
        try {
            this.ds.joinGroup(InetAddress.getByName(mCastAddr));
            Log.report(this, 2, 1, "Receiving on multicast group " + mCastAddr);
        }
        catch (Exception exc) {
            Log.report(this, 3, 3, "Cannot join multicast group " + mCastAddr);
        }
    }

    public void setHandler(PacketHandler _handler) {
        this.handler = _handler;
    }

    protected void open() {
        Log.report(this, 4, 1, "starting receiver on port " + this.ds.getLocalPort());
    }

    protected void close() {
        this.ds.close();
    }

    private void trybody() throws IOException {
        byte[] buffer = new byte[512];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        byte[] wpkt = dp.getData();
        Log.report(this, 4, 0, "Rx from port " + dp.getPort() + " on " + dp.getAddress().getHostAddress());
        if (this.stayAlive && dp.getAddress() != null) {
            String errMsg = "invalid packet: type=" + this.pw.getDataType(wpkt) + ", len=" + dp.getLength() + ", datalen=" + this.pw.getDataLength(wpkt) + " from " + dp.getAddress().getHostAddress();
            if (this.pw.isValidPacket(wpkt, dp.getLength())) {
                if (this.pw.getDataType(wpkt) == 195) {
                    CalibrationResponse calResponse = new CalibrationResponse(buffer, this.pw.getDataOffset(), this.pw.getDataLength(buffer));
                    Log.report(this, 5, 0, "got " + calResponse);
                    if (this.handler != null) {
                        this.handler.put(calResponse);
                    }
                } else {
                    Log.report(this, 1, 2, errMsg);
                }
            } else {
                Log.report(this, 2, 2, errMsg);
            }
        }
    }

    protected void body() {
        try {
            this.trybody();
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception any) {
            Log.report(this, 10, 3, any.toString());
        }
    }

    public static void main(String[] args) throws IOException {
        int port = 32000;
        String multicast = "230.1.2.1";
        String usage = "params are [p:udpPortNum] [m:mCastAddr]";
        int ix = 0;
        while (ix < args.length) {
            String arg = args[ix];
            if (arg.length() < 3) {
                System.out.println(usage);
                System.exit(0);
            }
            String choice = arg.substring(0, 2).toLowerCase();
            String val = arg.substring(2);
            if (choice.equals("p:")) {
                port = Integer.parseInt(val);
            } else if (choice.equals("m:")) {
                multicast = val;
            } else {
                System.out.println(usage);
                System.exit(0);
            }
            ++ix;
        }
        FileLog log = new FileLog(".", "CalibrationResponseReceiver.log");
        Log.installLog(log);
        log.setVerbosity(0);
        CalibrationResponseReceiver instance = new CalibrationResponseReceiver(port, multicast, null);
        instance.start();
    }
}

