/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;

public class CalibrationResponse
extends Packet {
    public static final int MSG_TYPE = 195;
    private float calib;
    private float calper;
    private String channel;
    private String station;
    private String response;
    private String recordID;
    private String handlerID;
    private String userID;
    private boolean inSpec;

    public CalibrationResponse(float _calib, float _calper, String _station, String _channel, String _response, String _recordID, String _handlerID, String _userID, boolean _inSpec) {
        this.calib = _calib;
        this.calper = _calper;
        this.station = _station;
        this.channel = _channel;
        this.response = _response;
        this.recordID = _recordID;
        this.handlerID = _handlerID;
        this.userID = _userID;
        this.inSpec = _inSpec;
    }

    public CalibrationResponse(byte[] buffer, int offset, int length) {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 195;
    }

    public int getDataLength() {
        return 8 + this.channel.length() + 1 + this.station.length() + 1 + this.response.length() + 1 + this.recordID.length() + 1 + this.handlerID.length() + 1 + this.userID.length() + 1 + 1;
    }

    public void writeTo(byte[] buffer, int offset) throws IllegalArgumentException {
        if (buffer.length < this.getDataLength()) {
            throw new IllegalArgumentException("writeTo: buffer too small");
        }
        BigEndian.writeFloat(buffer, offset, this.calib);
        BigEndian.writeFloat(buffer, offset += 4, this.calper);
        BigEndian.writeString(buffer, offset += 4, this.channel, this.channel.length() + 1);
        BigEndian.writeString(buffer, offset += this.channel.length() + 1, this.station, this.station.length() + 1);
        BigEndian.writeString(buffer, offset += this.station.length() + 1, this.response, this.response.length() + 1);
        BigEndian.writeString(buffer, offset += this.response.length() + 1, this.recordID, this.recordID.length() + 1);
        BigEndian.writeString(buffer, offset += this.recordID.length() + 1, this.handlerID, this.handlerID.length() + 1);
        BigEndian.writeString(buffer, offset += this.handlerID.length() + 1, this.userID, this.userID.length() + 1);
        buffer[offset += this.userID.length() + 1] = this.inSpec ? (byte)1 : 0;
        ++offset;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws IllegalArgumentException {
        if (buffer.length - offset < 8) {
            throw new IllegalArgumentException("readFrom: insufficient data.");
        }
        this.calib = BigEndian.readFloat(buffer, offset);
        this.calper = BigEndian.readFloat(buffer, offset += 4);
        this.channel = BigEndian.readString(buffer, offset += 4, length);
        this.station = BigEndian.readString(buffer, offset += this.channel.length() + 1, length);
        this.response = BigEndian.readString(buffer, offset += this.station.length() + 1, length);
        this.recordID = BigEndian.readString(buffer, offset += this.response.length() + 1, length);
        this.handlerID = BigEndian.readString(buffer, offset += this.recordID.length() + 1, length);
        this.userID = BigEndian.readString(buffer, offset += this.handlerID.length() + 1, length);
        this.inSpec = buffer[offset += this.userID.length() + 1] == 1;
    }

    public String getDottedChannelName() {
        return String.valueOf(this.getStation()) + "." + this.getChannel();
    }

    public float getCalib() {
        return this.calib;
    }

    public float getCalper() {
        return this.calper;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getStation() {
        return this.station;
    }

    public String getResponse() {
        return this.response;
    }

    public String getRecordID() {
        return this.recordID;
    }

    public String getHandlerID() {
        return this.handlerID;
    }

    public String getUserID() {
        return this.userID;
    }

    public boolean getInSpec() {
        return this.inSpec;
    }

    public String toString() {
        String s = "CalResp: " + this.getDottedChannelName() + " calib:" + this.calib + " calper:" + this.calper + " ID: " + this.handlerID + "." + this.recordID + " by user " + this.userID;
        return s;
    }
}

