/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Instrument;

public class ChannelKey {
    public static final int DATA_PACKET = 1;
    public static final int SOH_PACKET = 2;
    public static final int TIME_PACKET = 4;
    public static final int LOG_PACKET = 5;
    public static final int SERIAL_PACKET = 6;
    public static final int FILLER_PACKET = 9;
    protected static final String[] dataTypes = new String[]{"invalid", "data", "soh", "invalid", "time", "log", "serial"};
    private int key;

    public ChannelKey(int aKey) {
        this.key = aKey;
    }

    public ChannelKey(int type, int channel, int ID) {
        this.key = ChannelKey.getKeyOf(type, channel, ID);
    }

    public int getID() {
        return ChannelKey.getIDOf(this.key);
    }

    public int getType() {
        return ChannelKey.getTypeOf(this.key);
    }

    public int getChannel() {
        return ChannelKey.getChannelOf(this.key);
    }

    public int getModel() {
        return ChannelKey.getModelOf(this.key);
    }

    public String toString() {
        return ChannelKey.getKeyStringOf(this.key);
    }

    public static int getKeyOf(int type, int channel, int ID) {
        return ID << 16 | (type & 0xFF) << 8 | channel & 0xFF;
    }

    public static int getIDOf(int key) {
        return key >> 16 & 0xFFFF;
    }

    public static int getTypeOf(int key) {
        return key >> 8 & 0xFF;
    }

    public static int getChannelOf(int key) {
        return key & 0xFF;
    }

    public static int getModelOf(int key) {
        return Instrument.getModelOf(ChannelKey.getIDOf(key));
    }

    public static String getKeyStringOf(int key) {
        int ID = ChannelKey.getIDOf(key);
        int type = ChannelKey.getTypeOf(key);
        String typeName = String.valueOf(type);
        if (type < dataTypes.length) {
            typeName = dataTypes[type];
        }
        int channel = ChannelKey.getChannelOf(key);
        if (type == 1) {
            ++channel;
        }
        if (type == 6 && channel >= 16) {
            typeName = "auth";
            channel -= 15;
        }
        return String.valueOf(Instrument.getNameOf(ID)) + ":" + typeName + " " + channel;
    }
}

