/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.PacketPrinter;
import ca.nanometrics.packet.ReTxRequestPacket;
import ca.nanometrics.packet.SampleRateTable;
import ca.nanometrics.util.LittleEndian;

public class PacketRingBuffer
implements NmxPacketHandler,
HrdCommandHandler {
    static final int DEFAULT_SEND_LIMIT = 10;
    private int key;
    private int capacity;
    NmxPacketHandler handler;
    private PacketHolder[] ringBuffer;
    private int packetCount;
    private int oldestIndex;
    private int newestSequence;
    private int oldestSequence;
    private int sendLimit;
    private boolean retxPending;

    public PacketRingBuffer(int channelKey, int rbfCapacity, NmxPacketHandler pktHandler) {
        this.key = channelKey;
        this.capacity = rbfCapacity;
        if (this.capacity < 1) {
            this.capacity = 1;
        }
        this.handler = pktHandler;
        this.ringBuffer = new PacketHolder[this.capacity];
        int ix = 0;
        while (ix < this.capacity) {
            this.ringBuffer[ix] = new PacketHolder();
            ++ix;
        }
        this.packetCount = 0;
        this.oldestIndex = 0;
        this.newestSequence = 0;
        this.oldestSequence = 0;
        this.retxPending = false;
        this.sendLimit = 10;
    }

    public void setHandler(NmxPacketHandler pktHandler) {
        this.handler = pktHandler;
    }

    public void setSendLimit(int limit) {
        if (limit >= 0) {
            this.sendLimit = limit;
        }
    }

    private int indexOf(int ix) {
        return (this.oldestIndex + ix) % this.capacity;
    }

    public synchronized void clear() {
        this.packetCount = 0;
    }

    public synchronized void put(NmxPacket packet) {
        if (packet == null) {
            return;
        }
        if (packet.getKey() == this.key) {
            int packetSequence = packet.getSequenceNumber();
            if (packetSequence <= this.newestSequence) {
                this.clear();
            }
            this.newestSequence = packetSequence;
            if (this.capacity > 0) {
                this.ringBuffer[this.indexOf(this.packetCount)].setPacket(packet);
                if (this.packetCount < this.capacity) {
                    ++this.packetCount;
                } else {
                    this.oldestIndex = this.indexOf(1);
                }
            }
            this.oldestSequence = this.newestSequence + 1 - this.packetCount;
            this.send(packet);
            this.forwardPendingRetx(this.sendLimit);
        }
    }

    public synchronized void put(HrdCommandPacket command) {
        if (command != null && command instanceof ReTxRequestPacket) {
            ReTxRequestPacket request = (ReTxRequestPacket)command;
            System.out.println("retx " + request + " key " + request.getKey() + " want " + this.key);
            if (request.getRequestedKey() == this.key) {
                int firstRequested = request.getFirstSequence();
                int lastRequested = request.getLastSequence();
                if (firstRequested < this.oldestSequence) {
                    firstRequested = this.oldestSequence;
                }
                if (lastRequested > this.newestSequence) {
                    lastRequested = this.newestSequence;
                }
                this.retxPending = true;
                int ix = firstRequested;
                while (ix <= lastRequested) {
                    this.ringBuffer[this.indexOf(ix - this.oldestSequence)].setRequested(true);
                    ++ix;
                }
                this.forwardPendingRetx(this.sendLimit);
            }
        }
    }

    public synchronized void forwardPendingRetx(int limit) {
        if (!this.retxPending) {
            return;
        }
        int count = 0;
        int ix = 0;
        while (ix < this.packetCount) {
            if (count >= limit) {
                return;
            }
            int index = this.indexOf(ix);
            if (this.ringBuffer[index].isRequested()) {
                this.ringBuffer[index].setRequested(false);
                NmxPacket packet = this.ringBuffer[index].getPacket();
                packet.setReTx(true);
                this.send(packet);
                ++count;
            }
            ++ix;
        }
        this.retxPending = false;
    }

    public boolean isRetxPending() {
        return this.retxPending;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void send(NmxPacket packet) {
        if (this.handler != null) {
            packet.setOldestSequence(this.oldestSequence);
            this.handler.put(packet);
        }
    }

    public static void main(String[] args) throws Exception {
        int ID = 101;
        int type = 1;
        int channel = 0;
        int sampleRate = 100;
        int sampleIndex = SampleRateTable.getIndex(sampleRate);
        byte channelByte = (byte)(sampleIndex << 3 | channel);
        int key = ChannelKey.getKeyOf(type, channel, ID);
        PacketPrinter pp = new PacketPrinter();
        PacketRingBuffer prbf = new PacketRingBuffer(key, 6, pp);
        int ix = 0;
        while (ix < 30) {
            if (ix == 9) {
                prbf.clear();
            }
            byte[] buffer = new byte[34];
            int seq = 100 + ix;
            int time = seq + 1000;
            int frac = 1000 - seq;
            int fval = 0;
            buffer[0] = 1;
            LittleEndian.writeInt(buffer, 1, time);
            LittleEndian.writeShort(buffer, 5, (short)frac);
            LittleEndian.writeShort(buffer, 7, (short)ID);
            LittleEndian.writeInt(buffer, 9, seq);
            buffer[13] = channelByte;
            LittleEndian.writeInt24(buffer, 14, fval);
            buffer[17] = 9;
            DataPacket ndp = new DataPacket(buffer, 0);
            prbf.put(ndp);
            if (ix % 6 == 0) {
                prbf.put(new ReTxRequestPacket(1000, ID, type, channel, seq - 5, seq - 4));
            }
            ++ix;
        }
    }

    class PacketHolder {
        private NmxPacket packet = null;
        private boolean requested = false;

        PacketHolder() {
        }

        void setPacket(NmxPacket pkt) {
            this.packet = pkt;
            this.requested = false;
        }

        void setRequested(boolean req) {
            this.requested = req;
        }

        NmxPacket getPacket() {
            return this.packet;
        }

        boolean isRequested() {
            return this.requested;
        }
    }
}

