/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.util.InvalidInputException;

public class SohPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 2;
    public static final int SOH_CHANNEL = 0;
    public static final String SUBTYPE_NAME = "Soh";
    public static final int FILE_TAG = 44;

    public SohPacket(byte[] buffer, int oldestAvailable) throws InvalidInputException {
        super(buffer, oldestAvailable);
    }

    public SohPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    protected boolean isLengthOk(int length) {
        return length > 17 && length <= 1020 && length % 17 == 0;
    }

    public int getChannel() {
        return 0;
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public byte[] getBundle(int index) {
        byte[] bundle = new byte[17];
        int offset = index * 17;
        int i = 0;
        while (i < 17) {
            bundle[i] = this.guts[offset + i];
            ++i;
        }
        return bundle;
    }

    public String toString() {
        String str = String.valueOf(this.getInstrumentName()) + "-" + this.getSubTypeName() + ":" + this.getSequenceNumber() + " bundles:" + this.getNumBundles() + " @ " + this.getPacketTimeString();
        return str;
    }
}

