/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ByteEntryDocument
extends PlainDocument {
    private int maxLength = 3;
    private int maxValue = 255;

    public ByteEntryDocument() {
        this(255);
    }

    public ByteEntryDocument(int maxval) {
        this.maxValue = maxval >= 0 && maxval <= 255 ? maxval : 255;
    }

    public void insertString(int offset, String input, AttributeSet attr) throws BadLocationException {
        if (this.validateInput(input, offset)) {
            super.insertString(offset, input, attr);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean validateInput(String input, int offset) throws BadLocationException {
        if (this.getLength() + input.length() > this.maxLength) {
            return false;
        }
        int ix = 0;
        while (ix < input.length()) {
            char cix = input.charAt(ix);
            if (cix < '0' || cix > '9') {
                return false;
            }
            ++ix;
        }
        String oldText = this.getText(0, this.getLength());
        int txtLength = oldText.length();
        StringBuffer sb = new StringBuffer();
        if (offset > 0 && offset <= txtLength) {
            sb.append(oldText.substring(0, offset));
        }
        sb.append(input);
        if (offset < txtLength) {
            sb.append(oldText.substring(offset));
        }
        String newText = sb.toString();
        try {
            int val = Integer.parseInt(newText);
            if (val >= 0 && val <= this.maxValue) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

