/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.DateTimeDocument;
import ca.nanometrics.uitools.DelimitedDocument;
import ca.nanometrics.util.NmxDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateEntryDocument
extends DelimitedDocument
implements DateTimeDocument {
    public DateEntryDocument() {
        super("0123456789", "-/ ");
    }

    protected boolean checkIntArg(String token, int maxLength, int maxVal) {
        int val;
        if (token.length() > maxLength) {
            return false;
        }
        int n = val = token.length() > 0 ? Integer.parseInt(token) : 0;
        return val <= maxVal;
    }

    protected boolean isTextValid(String text) {
        int numTokens;
        String[] tokens;
        block9: {
            block8: {
                block7: {
                    int length = text.length();
                    if (length < 1) {
                        return true;
                    }
                    if (this.isDelimiter(text.charAt(0))) {
                        return false;
                    }
                    try {
                        tokens = this.tokenize(text);
                        numTokens = tokens.length;
                        if (numTokens <= 3) break block7;
                        return false;
                    }
                    catch (Exception any) {
                        return false;
                    }
                }
                if (numTokens <= 0 || this.checkIntArg(tokens[0], 4, 3999)) break block8;
                return false;
            }
            if (numTokens <= 1 || this.checkIntArg(tokens[1], 2, 12)) break block9;
            return false;
        }
        return numTokens <= 2 || this.checkIntArg(tokens[2], 2, 31);
    }

    public double getTimeValue(String text) {
        int year = 1970;
        int month = 0;
        int day = 1;
        try {
            String[] tokens = this.tokenize(text);
            year = Integer.parseInt(tokens[0]);
            month = Integer.parseInt(tokens[1]) - 1;
            day = Integer.parseInt(tokens[2]);
        }
        catch (Exception tokens) {
            // empty catch block
        }
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        gc.setTimeZone(TimeZone.getTimeZone("GMT"));
        return gc.getTime().getTime() / 1000L;
    }

    public String getTimeString(double time) {
        NmxDateFormat ndf = new NmxDateFormat("yyyy-MM-dd");
        return ndf.format(time);
    }
}

