/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.DateTimeDocument;
import ca.nanometrics.uitools.EntryField;
import javax.swing.text.Document;

public class DateTimeEntryField
extends EntryField {
    private double initValue;
    private DateTimeDocument doc;

    public DateTimeEntryField(DateTimeDocument document, double value, String helpKey) {
        super(document, helpKey);
        this.doc = document;
        this.setHorizontalAlignment(2);
        this.setValue(value, true);
    }

    public void setDocument(Document document) {
        boolean isDateDoc = document instanceof DateTimeDocument;
        if (this.doc != null && !isDateDoc) {
            throw new IllegalArgumentException("requires DateTimeDocument");
        }
        super.setDocument(document);
        if (isDateDoc) {
            this.doc = (DateTimeDocument)document;
        }
    }

    public boolean isChanged() {
        return this.getValue() != this.initValue;
    }

    public boolean isValid() {
        return true;
    }

    public double getInitValue() {
        return this.initValue;
    }

    public double getValue() {
        return this.doc.getTimeValue(this.getText());
    }

    public void setValue(double val, boolean init) {
        this.setText(this.doc.getTimeString(val));
        if (init) {
            this.initValue = this.getValue();
        }
        this.checkValue();
    }

    protected String getStringOf(double val) {
        return this.doc.getTimeString(val);
    }

    public void setValue(double val) {
        this.setValue(val, false);
    }

    public void initValue(double val) {
        this.setValue(val, true);
    }

    public void reset() {
        this.setValue(this.initValue);
    }

    protected void onFocusLost() {
        this.setValue(this.getValue());
    }
}

