/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.TimeEntryDocument;

public class DayToSecEntryDocument
extends TimeEntryDocument {
    protected boolean isTextValid(String text) {
        int numTokens;
        String[] tokens;
        block11: {
            block10: {
                block9: {
                    block8: {
                        int length = text.length();
                        if (length < 1) {
                            return true;
                        }
                        if (this.isDelimiter(text.charAt(0))) {
                            return false;
                        }
                        try {
                            tokens = this.tokenize(text);
                            numTokens = tokens.length;
                            if (numTokens <= 4) break block8;
                            return false;
                        }
                        catch (Exception any) {
                            return false;
                        }
                    }
                    if (numTokens <= 0 || this.checkIntArg(tokens[0], 3, 366)) break block9;
                    return false;
                }
                if (numTokens <= 1 || this.checkIntArg(tokens[1], 2, 25)) break block10;
                return false;
            }
            if (numTokens <= 2 || this.checkIntArg(tokens[2], 2, 61)) break block11;
            return false;
        }
        return numTokens <= 3 || this.checkIntArg(tokens[3], 2, 61);
    }

    public double getTimeValue(String text) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        try {
            String[] tokens = this.tokenize(text);
            days = Integer.parseInt(tokens[0]);
            hours = Integer.parseInt(tokens[1]);
            minutes = Integer.parseInt(tokens[2]);
            seconds = Integer.parseInt(tokens[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return days * 86400 + hours * 3600 + minutes * 60 + seconds;
    }

    public String getTimeString(double time) {
        int minutes;
        double timeLeft;
        int hours;
        int rounder = 10000;
        double frac = Math.round(time * (double)rounder);
        int days = (int)((time = frac / (double)rounder) / 86400.0);
        if (days > 365) {
            days = 365;
        }
        if ((hours = (int)((timeLeft = Math.abs(time - (double)(days * 24 * 3600))) / 3600.0)) > 24) {
            hours = 24;
        }
        if ((minutes = (int)((timeLeft = Math.abs(timeLeft - (double)(hours * 3600))) / 60.0)) > 60) {
            minutes = 60;
        }
        timeLeft = Math.abs(timeLeft - (double)(minutes * 60));
        int seconds = (int)timeLeft;
        StringBuffer sb = new StringBuffer();
        if (days < 10) {
            sb.append("00");
        } else if (days < 100) {
            sb.append('0');
        }
        sb.append(days);
        sb.append(':');
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        if (seconds < 10) {
            sb.append('0');
        }
        sb.append(seconds);
        return sb.toString();
    }
}

