/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.util.StrictTokenizer;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class DelimitedDocument
extends PlainDocument {
    private String permitted;
    private String delimiters;
    private char delimiter;

    protected DelimitedDocument(String permittedChars, String delimiterChars) {
        this.setPermitted(permittedChars);
        this.setDelimiters(delimiterChars);
    }

    protected DelimitedDocument() {
        this("0123456789", "-/ ");
    }

    private void setPermitted(String charset) {
        if (charset == null || charset.length() < 1) {
            throw new IllegalArgumentException("permitted.length < 1");
        }
        this.permitted = charset;
    }

    private void setDelimiters(String charset) {
        if (charset == null || charset.length() < 1) {
            throw new IllegalArgumentException("delimiters.length < 1");
        }
        this.delimiters = charset;
        this.delimiter = this.delimiters.charAt(0);
    }

    protected String getPermitted() {
        return this.permitted;
    }

    protected String getDelimiters() {
        return this.delimiters;
    }

    protected boolean isPermitted(int ch) {
        return this.permitted.indexOf(ch) >= 0;
    }

    protected boolean isDelimiter(int ch) {
        return this.delimiters.indexOf(ch) >= 0;
    }

    protected char getDelimiter() {
        return this.delimiter;
    }

    protected abstract boolean isTextValid(String var1);

    public void insertString(int offset, String input, AttributeSet attr) throws BadLocationException {
        input = this.makeValidInput(offset, input);
        super.insertString(offset, input, attr);
    }

    public void remove(int offset, int length) throws BadLocationException {
        String newText = this.removeText(offset, length);
        if (this.isTextValid(newText)) {
            super.remove(offset, length);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private String removeText(int offset, int length) throws BadLocationException {
        String oldText = this.getText(0, this.getLength());
        String beforeText = oldText.substring(0, offset);
        String afterText = oldText.substring(offset + length);
        return String.valueOf(beforeText) + afterText;
    }

    protected String[] tokenize(String text) {
        StrictTokenizer st = new StrictTokenizer(text, this.getDelimiters());
        int numTokens = st.countTokens();
        String[] tokens = new String[numTokens];
        int ix = 0;
        while (ix < numTokens) {
            tokens[ix] = st.nextToken();
            ++ix;
        }
        return tokens;
    }

    private String makeValidInput(int offset, String input) throws BadLocationException {
        String oldText = this.getText(0, this.getLength());
        String preText = oldText.substring(0, offset);
        String postText = oldText.substring(offset);
        String preChar = preText;
        char delimiter = this.getDelimiter();
        boolean lastIsDelimiter = false;
        if (preText.length() > 0) {
            lastIsDelimiter = this.isDelimiter(preText.charAt(preText.length() - 1));
        }
        StringBuffer insertBuffer = new StringBuffer();
        int inputLength = input.length();
        int ix = 0;
        while (ix < inputLength) {
            char nextChar = input.charAt(ix);
            boolean nextIsDelimiter = this.isDelimiter(nextChar);
            if (nextIsDelimiter) {
                nextChar = delimiter;
            }
            if (!(lastIsDelimiter && nextIsDelimiter || !nextIsDelimiter && !this.isPermitted(nextChar))) {
                if (this.isTextValid(String.valueOf(preChar) + nextChar + postText)) {
                    insertBuffer.append(nextChar);
                    preChar = String.valueOf(preText) + insertBuffer;
                    lastIsDelimiter = nextIsDelimiter;
                } else if (this.isTextValid(String.valueOf(preChar) + delimiter + nextChar + postText)) {
                    insertBuffer.append(delimiter);
                    insertBuffer.append(nextChar);
                    preChar = String.valueOf(preText) + insertBuffer;
                    lastIsDelimiter = nextIsDelimiter;
                }
            }
            ++ix;
        }
        return insertBuffer.toString();
    }
}

