/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.PopupHelp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public abstract class EntryField
extends JTextField {
    protected Color invalidForeground = Color.red;
    protected Color changedForeground = Color.blue;
    protected Color normalForeground = Color.black;
    private String helpKey;

    public EntryField(Document doc, String helpKeyword) {
        super(doc, "", 0);
        this.helpKey = helpKeyword;
        if (this.helpKey != null) {
            this.setToolTipText(NmxHelp.getToolTip(this.helpKey));
            if (NmxHelp.hasHelp(this.helpKey)) {
                String fieldName = NmxHelp.getFieldName(this.helpKey, this.helpKey);
                this.addMouseListener(new PopupHelp(fieldName, this.helpKey));
            }
        }
        this.addFocusListener(new TextSelector());
        this.addKeyListener(new ResetListener());
        this.getDocument().addDocumentListener(new ChangeTracker());
    }

    public void setNormalForeground(Color color) {
        this.normalForeground = color;
    }

    public void setChangedForeground(Color color) {
        this.changedForeground = color;
    }

    public void setInvalidForeground(Color color) {
        this.invalidForeground = color;
    }

    public String getHelpKey() {
        return this.helpKey;
    }

    public abstract boolean isChanged();

    public abstract boolean isValid();

    protected abstract void reset();

    protected abstract void onFocusLost();

    protected void checkValue() {
        if (!this.isValid()) {
            this.setForeground(this.invalidForeground);
        } else if (this.isChanged()) {
            this.setForeground(this.changedForeground);
        } else {
            this.setForeground(this.normalForeground);
        }
    }

    public void setCurrentSizePreferred() {
        this.setPreferredSize(null);
        this.setPreferredSize(this.getPreferredSize());
    }

    public void setPreferredTextSize(String text) {
        this.setPreferredSize(null);
        Dimension dim = this.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        dim.width = insets.left + insets.right + fm.stringWidth(text);
        this.setPreferredSize(dim);
    }

    public void setPreferredTextSize(int numDigits) {
        if (numDigits < 1) {
            numDigits = 1;
        }
        StringBuffer sb = new StringBuffer("");
        int ix = 0;
        while (ix < numDigits) {
            sb.append('0');
            ++ix;
        }
        this.setPreferredTextSize(sb.toString());
    }

    private class ChangeTracker
    implements DocumentListener {
        private ChangeTracker() {
        }

        public void changedUpdate(DocumentEvent e) {
            EntryField.this.checkValue();
        }

        public void insertUpdate(DocumentEvent e) {
            EntryField.this.checkValue();
        }

        public void removeUpdate(DocumentEvent e) {
            EntryField.this.checkValue();
        }
    }

    private class ResetListener
    implements KeyListener {
        private ResetListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                EntryField.this.reset();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    protected class TextSelector
    extends FocusAdapter {
        protected TextSelector() {
        }

        public void focusGained(FocusEvent ev) {
            EntryField.this.selectAll();
        }

        public void focusLost(FocusEvent ev) {
            EntryField.this.onFocusLost();
        }
    }
}

