/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.DelimitedDocument;

public class IPAddressDocument
extends DelimitedDocument {
    public IPAddressDocument() {
        super("0123456789", ". ");
    }

    protected boolean checkIntArg(String token, int maxLength, int maxVal) {
        int val;
        if (token.length() > maxLength) {
            return false;
        }
        int n = val = token.length() > 0 ? Integer.parseInt(token) : 0;
        return val <= maxVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isTextValid(String text) {
        if (text.length() < 1) {
            return true;
        }
        if (this.isDelimiter(text.charAt(0))) {
            return false;
        }
        try {
            String[] tokens = this.tokenize(text);
            int numTokens = tokens.length;
            if (numTokens > 4) {
                return false;
            }
            int ix = 0;
            while (true) {
                if (ix >= numTokens) {
                    return true;
                }
                if (!this.checkIntArg(tokens[ix], 3, 255)) {
                    return false;
                }
                ++ix;
            }
        }
        catch (Exception any) {
            return false;
        }
    }

    public int getIPAddress(String text) {
        int address = 0;
        try {
            String[] tokens = this.tokenize(text);
            int numTokens = tokens.length;
            if (numTokens > 4) {
                numTokens = 4;
            }
            int ix = 0;
            while (ix < numTokens) {
                int val = Integer.parseInt(tokens[ix]);
                address |= (val & 0xFF) << 24 - 8 * ix;
                ++ix;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    public String getIPString(int address) {
        StringBuffer sb = new StringBuffer();
        sb.append(address >> 24 & 0xFF);
        sb.append('.');
        sb.append(address >> 16 & 0xFF);
        sb.append('.');
        sb.append(address >> 8 & 0xFF);
        sb.append('.');
        sb.append(address & 0xFF);
        return sb.toString();
    }
}

