/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.ByteEntryField;
import ca.nanometrics.uitools.NmxHelp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IPEntryField
extends JPanel {
    protected Color changedForeground = Color.blue;
    protected Color normalForeground = Color.black;
    private ByteEntryField[] ipField;
    private JTextField[] fields;
    private int initValue;
    private int preferredWidth;

    public IPEntryField(String helpKey, int width, boolean isMask) {
        int firstval;
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.ipField = new ByteEntryField[4];
        this.fields = new JTextField[7];
        this.initValue = 0;
        int maxval = firstval = isMask ? 255 : 239;
        int ix = 0;
        while (ix < 4) {
            this.ipField[ix] = this.createField(maxval);
            this.fields[2 * ix] = this.ipField[ix];
            if (ix < 3) {
                this.fields[2 * ix + 1] = this.createDot();
            }
            maxval = 255;
            ++ix;
        }
        this.add(Box.createHorizontalStrut(15));
        ix = 0;
        while (ix < 7) {
            this.add(this.fields[ix]);
            ++ix;
        }
        this.add(Box.createHorizontalStrut(15));
        this.setToolTipText(NmxHelp.getToolTip(helpKey));
        this.setPreferredWidth(width);
        ChangeTracker tracker = new ChangeTracker();
        int ix2 = 0;
        while (ix2 < 4) {
            this.ipField[ix2].getDocument().addDocumentListener(tracker);
            ++ix2;
        }
    }

    private ByteEntryField createField(int maxval) {
        ByteEntryField tf = new ByteEntryField(maxval);
        tf.setBorder(null);
        tf.optimizeSize();
        return tf;
    }

    private JTextField createDot() {
        JTextField tf = new JTextField(".");
        tf.setBorder(null);
        tf.setPreferredSize(tf.getPreferredSize());
        tf.setHorizontalAlignment(4);
        tf.setEnabled(false);
        return tf;
    }

    public void setEnabled(boolean toEnable) {
        if (this.ipField != null) {
            int ix = 0;
            while (ix < 4) {
                this.ipField[ix].setEnabled(toEnable);
                ++ix;
            }
        }
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.fields != null) {
            int ix = 0;
            while (ix < 7) {
                this.fields[ix].setToolTipText(text);
                ++ix;
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fields != null) {
            int ix = 0;
            while (ix < 7) {
                this.fields[ix].setForeground(color);
                ++ix;
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fields != null) {
            int ix = 0;
            while (ix < 7) {
                this.fields[ix].setFont(font);
                ++ix;
            }
            ix = 0;
            while (ix < 4) {
                this.ipField[ix].optimizeSize();
                ++ix;
            }
        }
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.preferredWidth > 0) {
            dim.width = this.preferredWidth;
        }
        return dim;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void checkValue() {
        int addr = this.getIPAddress();
        if (addr != this.initValue) {
            this.setForeground(this.changedForeground);
        } else {
            this.setForeground(this.normalForeground);
        }
    }

    public void setIPAddress(int val, boolean init) {
        int ix = 0;
        while (ix < 4) {
            int bval = val >> 8 * (3 - ix) & 0xFF;
            this.ipField[ix].setValue(bval);
            ++ix;
        }
        if (init) {
            this.initValue = val;
        }
        this.checkValue();
    }

    public int getIPAddress() {
        int address = 0;
        address |= (this.ipField[0].getValue() & 0xFF) << 24;
        address |= (this.ipField[1].getValue() & 0xFF) << 16;
        address |= (this.ipField[2].getValue() & 0xFF) << 8;
        return address |= this.ipField[3].getValue() & 0xFF;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        int ix = 0;
        while (ix < 4) {
            sb.append(this.ipField[ix].getText());
            if (ix < 3) {
                sb.append(".");
            }
            ++ix;
        }
        return sb.toString();
    }

    private class ChangeTracker
    implements DocumentListener {
        private ChangeTracker() {
        }

        public void changedUpdate(DocumentEvent e) {
            IPEntryField.this.checkValue();
        }

        public void insertUpdate(DocumentEvent e) {
            IPEntryField.this.checkValue();
        }

        public void removeUpdate(DocumentEvent e) {
            IPEntryField.this.checkValue();
        }
    }
}

