/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.IntValidator;

public class IntRangeValidator
implements IntValidator {
    private int minValue;
    private int maxValue;

    public IntRangeValidator() {
        this.setMinValue(Integer.MIN_VALUE);
        this.setMaxValue(Integer.MAX_VALUE);
    }

    public IntRangeValidator(int rangemin, int rangemax) {
        this.setMinValue(rangemin);
        this.setMaxValue(rangemax);
    }

    public boolean isValid(int value) {
        return this.getMinValue() <= value && value <= this.getMaxValue();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMinValue());
        sb.append(" <= x <= ");
        sb.append(this.getMaxValue());
        return sb.toString();
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public int getMinValue() {
        return this.minValue;
    }
}

