/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class JavaObjectTransferable
implements Transferable {
    private Object data;
    private DataFlavor[] flavors;

    public JavaObjectTransferable(Object data) {
        this.data = data;
        this.setSupportedInterfaces(this.getInterfaceList(data.getClass()));
    }

    public JavaObjectTransferable(Object data, List interfaces) {
        this.data = data;
        this.setSupportedInterfaces(interfaces);
    }

    public void setSupportedInterfaces(List interfaces) {
        this.flavors = new DataFlavor[interfaces.size()];
        int index = 0;
        while (index < interfaces.size()) {
            Class curClass = (Class)interfaces.get(index);
            this.flavors[index] = new DataFlavor(curClass, curClass.getName());
            ++index;
        }
    }

    public List getInterfaceList(Class aClass) {
        Vector classList = new Vector();
        Class curClass = aClass;
        do {
            classList.add(curClass);
            Class<?>[] interfaces = curClass.getInterfaces();
            if (interfaces == null || interfaces.length <= 0) continue;
            int index = 0;
            while (index < interfaces.length) {
                classList.add(interfaces[index]);
                ++index;
            }
        } while ((curClass = curClass.getSuperclass()) != null);
        return classList;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] newList = new DataFlavor[this.flavors.length];
        System.arraycopy(this.flavors, 0, newList, 0, this.flavors.length);
        return newList;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int index = 0;
        while (index < this.flavors.length) {
            if (this.flavors[index].equals(flavor)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

