/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.ReactiveJButton;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;

public class LocJDialog
extends JDialog {
    private static Component defaultCenterComponent = null;
    private Component centerComponent = null;
    private boolean successFlag = true;

    public static Component getDefaultCenterComponent() {
        return defaultCenterComponent;
    }

    public static void setDefaultCenterComponent(Component comp) {
        defaultCenterComponent = comp;
    }

    public Component getCenterComponent() {
        return this.centerComponent;
    }

    public void setCenterComponent(Component comp) {
        this.centerComponent = comp;
    }

    public static Component getDefaultWindow() {
        if (defaultCenterComponent != null) {
            return defaultCenterComponent;
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
    }

    public void centerDialog() {
        int height;
        int width;
        int y;
        int x;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Component centerComp = this.getCenterComponent();
        if (centerComp == null) {
            centerComp = LocJDialog.getDefaultWindow();
        }
        if (centerComp == null) {
            x = 0;
            y = 0;
            width = (int)screen.getWidth();
            height = (int)screen.getHeight();
        } else {
            x = centerComp.getX();
            y = centerComp.getY();
            width = centerComp.getWidth();
            height = centerComp.getHeight();
        }
        y += (height - this.getHeight()) / 2;
        if ((x += (width - this.getWidth()) / 2) + this.getWidth() > screen.width) {
            x = screen.width - this.getWidth();
        }
        if (y + this.getHeight() > screen.height) {
            y = screen.height - this.getHeight();
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setLocation(x, y);
    }

    protected JButton createButton(String name, String bTip, boolean etched) {
        ReactiveJButton aButton = new ReactiveJButton(BorderFactory.createRaisedBevelBorder(), etched ? BorderFactory.createEtchedBorder() : BorderFactory.createEmptyBorder());
        aButton.setText(name);
        aButton.setToolTipText(bTip);
        Dimension aDimension = aButton.getPreferredSize();
        int width = (int)aDimension.getWidth();
        width = width < 50 ? 50 : width;
        aButton.setPreferredSize(new Dimension(width, 30));
        return aButton;
    }

    protected JButton createButton(String name, String bTip, boolean etched, ActionListener listener) {
        JButton aButton = this.createButton(name, bTip, etched);
        aButton.addActionListener(listener);
        return aButton;
    }

    public boolean getResult() {
        return this.successFlag;
    }

    protected void dispose(boolean success) {
        this.successFlag = success;
        super.dispose();
    }

    public void dispose() {
        this.dispose(false);
    }

    private void setUpActionOnCloseOperation() {
        this.setDefaultCloseOperation(2);
    }

    protected void initializeDefaultSettings() {
        this.setUpActionOnCloseOperation();
        this.setResizable(false);
    }

    public LocJDialog() {
        super(LocJDialog.getDefaultWindow() instanceof Frame ? (Frame)LocJDialog.getDefaultWindow() : null);
        this.centerComponent = defaultCenterComponent;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Dialog owner) {
        super(owner);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Dialog owner, String title) {
        super(owner, title);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Frame owner) {
        super(owner);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Frame owner, String title) {
        super(owner, title);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    public LocJDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.centerComponent = owner;
        this.initializeDefaultSettings();
    }

    protected class CancelButtonAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            LocJDialog.this.dispose(false);
        }
    }

    protected class OkButtonAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            LocJDialog.this.dispose(true);
        }
    }
}

