/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

public class MultiObjectTransferable
implements Transferable {
    private ArrayList data = new ArrayList();
    private ArrayList flavors = new ArrayList();

    public void addObject(Object data, Class flavor) {
        this.data.add(data);
        this.flavors.add(new DataFlavor(flavor, flavor.getName()));
    }

    public void removeObject(Object dataObj) {
        int index = this.data.indexOf(dataObj);
        if (index >= 0) {
            this.data.remove(index);
            this.flavors.remove(index);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] newList = new DataFlavor[this.flavors.size()];
        int index = 0;
        while (index < newList.length) {
            newList[index] = (DataFlavor)this.flavors.get(index);
            ++index;
        }
        return newList;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int index = 0;
        while (index < this.flavors.size()) {
            if (((DataFlavor)this.flavors.get(index)).equals(flavor)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        int index = 0;
        while (index < this.flavors.size()) {
            if (((DataFlavor)this.flavors.get(index)).equals(flavor)) {
                return this.data.get(index);
            }
            ++index;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

