/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.StatusBarPanel;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.Vector;

public class StatusBar {
    private StatusBarPanel bar;
    private int defaultField = 0;
    private Vector[] stateLists;

    public StatusBar(Container panel, Object location, int numFields, int elasticField) {
        this.bar = new StatusBarPanel(numFields, elasticField);
        this.attachToPanel(panel, location);
        this.defaultField = elasticField;
        this.stateLists = new Vector[numFields];
        int curField = 0;
        while (curField < numFields) {
            this.stateLists[curField] = new Vector();
            ++curField;
        }
    }

    public void attachToPanel(Container panel, Object location) {
        panel.add((Component)this.bar, location);
    }

    public void removeFromPanel(Container panel) {
        panel.remove(this.bar);
    }

    public Object addState(String state, int priority) {
        return this.addState(this.defaultField, state, priority);
    }

    public String getHighestStateString(int field) {
        StateElement ele = this.getHighestState(field);
        return ele.toString();
    }

    private StateElement getHighestState(int field) {
        Iterator iter = this.stateLists[field].iterator();
        if (iter.hasNext()) {
            StateElement highestState = (StateElement)iter.next();
            while (iter.hasNext()) {
                StateElement curState = (StateElement)iter.next();
                if (curState.priority < highestState.priority) continue;
                highestState = curState;
            }
            return highestState;
        }
        return null;
    }

    public Object push(String state) {
        return this.push(this.defaultField, state);
    }

    public Object push(int field, String state) {
        StateElement highestState = this.getHighestState(field);
        if (highestState == null) {
            return this.addState(field, state, 0);
        }
        return this.addState(field, state, highestState.priority);
    }

    public void pop() {
        this.pop(this.defaultField);
    }

    public void pop(int field) {
        StateElement highestState = this.getHighestState(field);
        if (highestState != null) {
            this.removeState(highestState);
        }
    }

    public Object addState(int field, String state, int priority) {
        if (this.stateLists.length <= field) {
            field = this.defaultField;
        }
        StateElement element = new StateElement(state, priority);
        this.stateLists[field].add(element);
        this.redraw(field);
        return element;
    }

    public int getNumStates(int field) {
        if (this.stateLists.length <= field) {
            field = this.defaultField;
        }
        return this.stateLists[field].size();
    }

    public int getNumStates() {
        return this.getNumStates(this.defaultField);
    }

    public void removeState(Object id) {
        this.removeState(this.defaultField, id);
    }

    public void removeState(int field, Object id) {
        this.stateLists[field].remove(id);
        this.redraw(field);
    }

    public void print(String text) {
        this.print(this.defaultField, text);
    }

    public void print(int field, String text) {
        this.bar.setField(field, text);
    }

    public void redraw() {
        this.redraw(this.defaultField);
    }

    public void redraw(int field) {
        StateElement highestState;
        if (this.stateLists.length <= field) {
            field = this.defaultField;
        }
        if ((highestState = this.getHighestState(field)) != null) {
            this.bar.setField(field, highestState.name);
        } else {
            this.bar.clearField(field);
        }
        this.bar.paintImmediately(0, 0, this.bar.getWidth(), this.bar.getHeight());
    }

    public void setFieldSize(int field, int numChar) {
        this.bar.setFieldSize(field, numChar);
    }

    public int getFieldSize(int field) {
        return this.bar.getFieldSize(field);
    }

    public StatusBarPanel getStatusBar() {
        return this.bar;
    }

    private class StateElement {
        public String name;
        public int priority;

        public StateElement(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }

        public String toString() {
            return this.name;
        }
    }
}

