/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class StatusBarPanel
extends JPanel {
    private static final String BLANKS = "        ";
    private JLabel[] labels;
    private int[] numChars;

    public StatusBarPanel(int numFields, int elasticField) {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        if (numFields < 1) {
            numFields = 1;
        }
        if (elasticField >= numFields) {
            elasticField = numFields - 1;
        }
        this.labels = new JLabel[numFields];
        this.numChars = new int[numFields];
        int ix = 0;
        while (ix < numFields) {
            this.labels[ix] = new JLabel(BLANKS);
            this.labels[ix].setBorder(new BevelBorder(1));
            gbc.gridx = ix;
            gbc.weightx = ix == elasticField ? 1.0 : 0.0;
            gbl.setConstraints(this.labels[ix], gbc);
            this.add(this.labels[ix]);
            ++ix;
        }
    }

    public void setNumChars(int field, int numChar) {
        if (field >= 0 && field < this.labels.length) {
            this.numChars[field] = numChar;
        }
    }

    public void setFieldSize(int field, int numChar) {
        if (field >= 0 && field < this.labels.length) {
            this.setNumChars(field, numChar);
            int maxCharWidth = this.getFontMetrics(this.getFont()).charWidth('8');
            int maxCharHeight = this.getFontMetrics(this.getFont()).getHeight();
            this.labels[field].setPreferredSize(new Dimension(maxCharWidth * numChar, maxCharHeight));
        }
    }

    public void setField(int field, String text) {
        if (field >= 0 && field < this.labels.length) {
            this.labels[field].setText(text);
        }
    }

    public void clearField(int field) {
        this.setField(field, BLANKS);
    }

    public int getFieldSize(int field) {
        if (field >= 0 && field < this.numChars.length) {
            return this.numChars[field];
        }
        return 0;
    }
}

