/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import ca.nanometrics.uitools.EntryField;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.TextValidator;
import javax.swing.text.PlainDocument;

public class TextEntryField
extends EntryField {
    protected static final TextValidator nullValidator = new NullValidator();
    private String initValue;
    private TextValidator validator;

    public TextEntryField(String value, TextValidator dv, String helpKey) {
        super(new PlainDocument(), helpKey);
        this.setHorizontalAlignment(2);
        this.setValidator(dv);
        this.setValue(value, true);
    }

    public TextEntryField(String value, TextValidator dv) {
        this(value, dv, null);
    }

    public TextEntryField(String value, String helpKey) {
        this(value, null, helpKey);
    }

    public TextEntryField(String value) {
        this(value, null, null);
    }

    public boolean isChanged() {
        return !this.getValue().equals(this.initValue);
    }

    public boolean isValid() {
        return this.validator.isValid(this.getValue());
    }

    public String getValue() {
        return this.getText();
    }

    public void setValue(String val, boolean init) {
        if (init) {
            this.initValue = val;
        }
        this.setText(val);
        this.checkValue();
    }

    public void setValue(String val) {
        this.setValue(val, false);
    }

    public void initValue(String val) {
        this.setValue(val, true);
    }

    public void reset() {
        this.setValue(this.initValue);
    }

    protected void onFocusLost() {
    }

    public void setValidator(TextValidator dv) {
        this.validator = dv == null ? nullValidator : dv;
        this.setToolTipText(String.valueOf(NmxHelp.getToolTip(this.getHelpKey(), "")) + " (" + this.validator.getDescription() + ")");
    }

    protected static class NullValidator
    implements TextValidator {
        protected NullValidator() {
        }

        public boolean isValid(String value) {
            return true;
        }

        public String getDescription() {
            return "unconstrained";
        }
    }
}

