/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class VTextIcon
implements Icon {
    private String text;
    private int width = 5;
    private int height = 5;
    private int minHeight = 0;
    private int minWidth = 0;

    public VTextIcon(String iconText, Component c) {
        this(iconText, c, 0, 0);
    }

    public VTextIcon(String iconText, Component c, int minimumHeight, int minimumWidth) {
        this.text = iconText;
        this.minHeight = minimumHeight;
        this.minWidth = minimumWidth;
        try {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            this.height = fm.stringWidth(this.text);
            this.width = fm.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getIconHeight() {
        int iconHeight = this.height + 20;
        if (iconHeight < this.minHeight) {
            iconHeight = this.minHeight;
        }
        return iconHeight;
    }

    public int getIconWidth() {
        int iconWidth = this.width - 10;
        if (iconWidth < this.minWidth) {
            iconWidth = this.minWidth;
        }
        return iconWidth;
    }

    public void paintIcon(Component c, Graphics gc, int x, int y) {
        try {
            Font font = c.getFont();
            FontMetrics fm = c.getFontMetrics(font);
            int textwidth = fm.stringWidth(this.text);
            int textheight = fm.getHeight();
            Graphics2D g2d = (Graphics2D)gc;
            g2d.translate(x, y);
            g2d.rotate(-1.5707963267948966);
            int xloc = (textwidth + this.getIconHeight()) / 2;
            int yloc = (textheight - this.getIconWidth()) / 2 - fm.getAscent();
            g2d.drawString(this.text, -xloc, -yloc);
            g2d.rotate(1.5707963267948966);
            g2d.translate(-x, -y);
            this.height = textwidth;
            this.width = textheight;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

