/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools;

import java.util.Vector;
import javax.swing.AbstractListModel;

public class VectorListModel
extends AbstractListModel {
    private Vector list = new Vector();
    private int maxSize = 0;

    public int getSize() {
        return this.list.size();
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Object getElementAt(int ix) {
        if (ix >= 0 && ix < this.list.size()) {
            return this.list.elementAt(ix);
        }
        return null;
    }

    public void append(Object obj) {
        int element = this.getSize();
        this.list.addElement(obj);
        this.fireIntervalAdded(this, element, element);
        if (this.maxSize > 0 && element >= this.maxSize) {
            this.remove(0, this.maxSize / 4);
        }
    }

    public void remove(Object obj) {
        this.remove(this.list.indexOf(obj));
    }

    public void remove(int first, int last) {
        int size = this.getSize();
        if (first < 0) {
            first = 0;
        }
        if (last >= size) {
            last = size;
        }
        if (first <= last) {
            int index = first;
            while (index <= last) {
                this.list.removeElementAt(first);
                ++index;
            }
            this.fireIntervalRemoved(this, first, last);
        }
    }

    public void remove(int index) {
        if (index >= 0 && index < this.getSize()) {
            this.list.removeElementAt(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void clear() {
        int size = this.getSize();
        this.list.clear();
        this.fireIntervalRemoved(this, 0, size - 1);
    }
}

