/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Vector;

public class MultiBorderLayout
implements LayoutManager2,
Serializable {
    int hgap;
    int vgap;
    Vector north = new Vector();
    Vector west = new Vector();
    Vector east = new Vector();
    Vector south = new Vector();
    Component center;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";

    public MultiBorderLayout() {
        this(0, 0);
    }

    public MultiBorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null) {
                name = CENTER;
            }
            if (CENTER.equals(name)) {
                this.center = comp;
            } else if (NORTH.equals(name)) {
                this.north.add(comp);
            } else if (SOUTH.equals(name)) {
                this.south.add(comp);
            } else if (EAST.equals(name)) {
                this.east.add(comp);
            } else if (WEST.equals(name)) {
                this.west.add(comp);
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.center) {
                this.center = null;
            } else if (this.north.contains(comp)) {
                this.north.remove(comp);
            } else if (this.south.contains(comp)) {
                this.south.remove(comp);
            } else if (this.east.contains(comp)) {
                this.east.remove(comp);
            } else if (this.west.contains(comp)) {
                this.west.remove(comp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c = null;
            int i = 0;
            while ((c = this.getChild(EAST, ltr, i)) != null) {
                d = c.getMinimumSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
                ++i;
            }
            i = 0;
            while ((c = this.getChild(WEST, ltr, i)) != null) {
                d = c.getMinimumSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
                ++i;
            }
            c = this.getChild(CENTER, ltr, 0);
            if (c != null) {
                Dimension d2 = c.getMinimumSize();
                dim.width += d2.width;
                dim.height = Math.max(d2.height, dim.height);
            }
            i = 0;
            while ((c = this.getChild(NORTH, ltr, i)) != null) {
                d = c.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
                ++i;
            }
            i = 0;
            while ((c = this.getChild(SOUTH, ltr, i)) != null) {
                d = c.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c = null;
            int i = 0;
            while ((c = this.getChild(EAST, ltr, i)) != null) {
                d = c.getPreferredSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
                ++i;
            }
            i = 0;
            while ((c = this.getChild(WEST, ltr, i)) != null) {
                d = c.getPreferredSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
                ++i;
            }
            c = this.getChild(CENTER, ltr, 0);
            if (c != null) {
                Dimension d2 = c.getPreferredSize();
                dim.width += d2.width;
                dim.height = Math.max(d2.height, dim.height);
            }
            i = 0;
            while ((c = this.getChild(NORTH, ltr, i)) != null) {
                d = c.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
                ++i;
            }
            i = 0;
            while ((c = this.getChild(SOUTH, ltr, i)) != null) {
                d = c.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c = null;
            int i = 0;
            while ((c = this.getChild(NORTH, ltr, i)) != null) {
                c.setSize(right - left, c.getHeight());
                d = c.getPreferredSize();
                c.setBounds(left, top, right - left, d.height);
                top += d.height + this.vgap;
                ++i;
            }
            i = 0;
            while ((c = this.getChild(SOUTH, ltr, i)) != null) {
                c.setSize(right - left, c.getHeight());
                d = c.getPreferredSize();
                c.setBounds(left, bottom - d.height, right - left, d.height);
                bottom -= d.height + this.vgap;
                ++i;
            }
            i = 0;
            while ((c = this.getChild(EAST, ltr, i)) != null) {
                c.setSize(c.getWidth(), bottom - top);
                d = c.getPreferredSize();
                c.setBounds(right - d.width, top, d.width, bottom - top);
                right -= d.width + this.hgap;
                ++i;
            }
            i = 0;
            while ((c = this.getChild(WEST, ltr, i)) != null) {
                c.setSize(c.getWidth(), bottom - top);
                d = c.getPreferredSize();
                c.setBounds(left, top, d.width, bottom - top);
                left += d.width + this.hgap;
                ++i;
            }
            c = this.getChild(CENTER, ltr, 0);
            if (c != null) {
                c.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    private Component getChild(String key, boolean ltr, int index) {
        Component result = null;
        try {
            if (key == NORTH) {
                result = (Component)this.north.get(index);
            } else if (key == SOUTH) {
                result = (Component)this.south.get(index);
            } else if (key == WEST) {
                result = (Component)this.west.get(index);
            } else if (key == EAST) {
                result = (Component)this.east.get(index);
            } else if (key == CENTER) {
                result = this.center;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }
}

