/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class VerFlowLayout
implements LayoutManager2,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int CENTER_BOX = 3;
    public static final int STRETCH = 4;
    private int align;
    int vgap;
    int horInsets;

    public VerFlowLayout() {
        this(1, 5);
    }

    public VerFlowLayout(int align) {
        this(align, 5);
    }

    public VerFlowLayout(int align, int vgap) {
        this(align, vgap, 0);
    }

    public VerFlowLayout(int align, int vgap, int horInsets) {
        this.vgap = vgap;
        this.horInsets = horInsets;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getPreferredSize();
                    dim.width = Math.max(dim.width, d.width);
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        dim.height += this.vgap;
                    }
                    dim.height += d.height;
                }
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.horInsets * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getMinimumSize();
                    dim.width = Math.max(dim.width, d.width);
                    if (i > 0) {
                        dim.height += this.vgap;
                    }
                    dim.height += d.height;
                }
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right * this.horInsets * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void centerComponent(Component target, int x, int y, int width, int height, int containerWidth, int containerHeight, int insetsLeft, int insetsRight) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 1: 
                case 3: {
                    x = (containerWidth - width) / 2;
                    if (x >= insetsLeft) break;
                    x = insetsLeft;
                    break;
                }
                case 2: {
                    x = containerWidth - width - insetsRight;
                    if (x >= insetsLeft) break;
                    x = insetsLeft;
                    break;
                }
                case 4: {
                    x = insetsLeft;
                    width = containerWidth - insetsRight - insetsLeft;
                    break;
                }
                default: {
                    x = insetsLeft;
                }
            }
            target.setBounds(x, y, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int nmembers = target.getComponentCount();
            int totalHeight = 0;
            int maxWidth = 0;
            int slackHeight = 0;
            int slackObjects = 0;
            int targetHeight = target.getHeight();
            int targetWidth = target.getWidth();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getPreferredSize();
                    totalHeight += d.height;
                    totalHeight += this.vgap;
                    if (d.height == 0) {
                        ++slackObjects;
                    }
                }
                ++i;
            }
            slackHeight = targetHeight - (totalHeight += insets.top + insets.bottom);
            if (slackHeight < 0) {
                slackHeight = 0;
            }
            int cury = this.vgap + insets.top;
            if (this.align == 3 && slackHeight / 2 > cury) {
                cury = slackHeight / 2;
            }
            int i2 = 0;
            while (i2 < nmembers) {
                Component m = target.getComponent(i2);
                if (m.isVisible()) {
                    Dimension d = (Dimension)m.getPreferredSize().clone();
                    if (d.width == 0) {
                        d.width = targetWidth;
                    }
                    maxWidth = Math.max(maxWidth, d.width);
                    if (d.height == 0) {
                        d.height = slackHeight / slackObjects;
                        slackHeight -= d.height;
                        --slackObjects;
                        if (d.height < this.vgap) {
                            this.centerComponent(m, 0, cury, d.width, 0, targetWidth, targetHeight, insets.left + this.horInsets, insets.right + this.horInsets);
                            cury += d.height;
                        } else {
                            d.height -= this.vgap;
                            this.centerComponent(m, 0, cury, d.width, d.height, targetWidth, targetHeight, insets.left + this.horInsets, insets.right + this.horInsets);
                            cury += d.height + this.vgap;
                        }
                    } else {
                        this.centerComponent(m, 0, cury, d.width, d.height, targetWidth, targetHeight, insets.left + this.horInsets, insets.right + this.horInsets);
                        cury += d.height + this.vgap;
                    }
                }
                ++i2;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

