/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.plot;

import ca.nanometrics.uitools.plot.TicInfo;

public class ScaleTicInfo
extends TicInfo {
    private double[] widthTable;

    public ScaleTicInfo(double width, double pixelWidth) {
        this.initWidthTable(width, pixelWidth);
        this.createTicLevels(width, pixelWidth);
    }

    protected double[] getWidthTable() {
        return this.widthTable;
    }

    public String getLabelOf(double value) {
        if (Math.abs(value) > 9999.0) {
            int power = (int)Math.floor(Math.log(Math.abs(value)) / Math.log(10.0));
            String result = String.valueOf(value);
            result = result.substring(0, value < 0.0 ? 2 : 1);
            return String.valueOf(result) + "e" + power;
        }
        double rounding = value < 0.0 ? -0.5 : 0.5;
        int intValue = (int)(value * 1000.0 + rounding);
        value = (double)intValue / 1000.0;
        return "" + value;
    }

    private void initWidthTable(double width, double pixelWidth) {
        double powerTen = Math.floor(Math.log(width / pixelWidth) / Math.log(10.0));
        double midValue = Math.pow(10.0, powerTen);
        this.widthTable = new double[]{midValue, midValue * 2.0, midValue * 5.0, midValue * 10.0, midValue * 20.0, midValue * 50.0, midValue * 100.0, midValue * 200.0, midValue * 500.0, midValue * 1000.0};
    }
}

