/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.plot;

public abstract class TicInfo {
    private static final double smallestUnitAllowed = 1.0E-4;
    private static final double minPixelsPerUnit = 4.0;
    private static final int MAXTICINC = 4;
    private double[] ticInc = new double[4];

    public TicInfo() {
    }

    public TicInfo(double width, double pixelWidth) {
        this.createTicLevels(width, pixelWidth);
    }

    public abstract String getLabelOf(double var1);

    protected abstract double[] getWidthTable();

    protected void createTicLevels(double unitWidth, double pixelWidth) {
        double[] widthTable = this.getWidthTable();
        int smallestUnit = this.getSmallestUnit(widthTable, unitWidth, pixelWidth);
        this.setTicIncrements(this.createTicIncrements(smallestUnit, widthTable));
    }

    protected double[] createTicIncrements(int smallestUnit, double[] widthTable) {
        double[] ticIncrements = new double[this.getMaxTicLevels()];
        int i = 0;
        while (i < this.getMaxTicLevels()) {
            ticIncrements[i] = widthTable[smallestUnit + i];
            ++i;
        }
        i = this.getMaxTicLevels() - 1;
        while (i > 0) {
            double rounded;
            double divided = Math.abs(ticIncrements[i] / ticIncrements[i - 1]);
            if (divided - (rounded = Math.rint(ticIncrements[i] / ticIncrements[i - 1])) > 5.0E-5) {
                ticIncrements[i - 1] = 0.0;
            }
            --i;
        }
        return ticIncrements;
    }

    protected int getSmallestUnit(double[] widthTable, double unitWidth, double pixelWidth) {
        int curUnit = 0;
        while (curUnit < widthTable.length) {
            if (widthTable[curUnit] / unitWidth * pixelWidth > 4.0) break;
            ++curUnit;
        }
        if (curUnit >= widthTable.length - 3) {
            curUnit = widthTable.length - 4;
        }
        return curUnit;
    }

    public void setTicIncrements(double[] ticIncrements) {
        int i = 0;
        while (i < this.getMaxTicLevels() || i < ticIncrements.length) {
            this.ticInc[i] = ticIncrements[i];
            ++i;
        }
    }

    public double getTicInc(int index) {
        if (index >= 0 && index < this.getMaxTicLevels()) {
            return this.ticInc[index];
        }
        return 0.0;
    }

    public int getMaxTicLevels() {
        return 4;
    }
}

