/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.plot;

import ca.nanometrics.uitools.plot.TicInfo;
import ca.nanometrics.util.UTCCalendar;

public class TimeTicInfo
extends TicInfo {
    private static final double[] widthTable = new double[]{1.0E-4, 2.0E-4, 5.0E-4, 0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 30.0, 60.0, 120.0, 300.0, 600.0, 1800.0, 3600.0, 7200.0, 14400.0, 43200.0, 86400.0, 172800.0, 345600.0, 691200.0, 1382400.0, 2678400.0, 5356800.0, 1.07136E7, 3.1536E7, 6.3072E7, 1.26144E8, 2.52288E8};

    public TimeTicInfo(double timeWidth, double pixelWidth) {
        super(timeWidth, pixelWidth);
    }

    protected double[] getWidthTable() {
        return widthTable;
    }

    public String getLabelOf(double val) {
        UTCCalendar converter = new UTCCalendar((long)(val * 1000.0 + 0.5));
        if (converter.get(14) > 0) {
            return converter.get(14) + "ms";
        }
        if (converter.get(13) > 0) {
            return converter.get(13) + "s";
        }
        if (converter.get(12) > 0) {
            return converter.get(12) + "m";
        }
        if (converter.get(11) > 0) {
            return converter.get(11) + "h";
        }
        if (converter.get(6) > 0) {
            return converter.get(6) + "d";
        }
        return converter.get(1) + "y";
    }
}

