/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.table;

import ca.nanometrics.uitools.table.TableMap;
import javax.swing.event.TableModelEvent;

public class IndexedTableMap
extends TableMap {
    protected int[] indexes = new int[0];
    protected int[] reverse = new int[0];

    protected synchronized void remap(boolean notifyListeners) {
        this.updateForwardMap();
        this.updateReverseMap();
        if (notifyListeners) {
            this.fireTableDataChanged();
        }
    }

    protected void updateForwardMap() {
        int modelRows = this.model.getRowCount();
        this.indexes = new int[modelRows];
        int row = 0;
        while (row < modelRows) {
            this.indexes[row] = row;
            ++row;
        }
    }

    protected final void updateReverseMap() {
        int modelRows = this.model.getRowCount();
        this.reverse = new int[modelRows];
        int row = 0;
        while (row < modelRows) {
            this.reverse[row] = -1;
            ++row;
        }
        row = 0;
        while (row < this.indexes.length) {
            this.reverse[this.indexes[row]] = row;
            ++row;
        }
    }

    public Object getValueAt(int row, int column) {
        if (this.indexes.length > row) {
            return this.model.getValueAt(this.indexes[row], column);
        }
        return null;
    }

    public void setValueAt(Object value, int row, int column) {
        this.model.setValueAt(value, this.indexes[row], column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(this.indexes[row], column);
    }

    public int getRowCount() {
        return this.indexes.length;
    }

    public void tableChanged(TableModelEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        int modelRows = this.reverse.length;
        if (firstRow == -1) {
            this.remap(false);
            this.fireTableChanged(e);
        } else if (modelRows != this.model.getRowCount() || lastRow >= modelRows || e.getType() != 0) {
            this.remap(true);
        } else {
            int inrow = firstRow;
            while (inrow <= lastRow) {
                int outrow = this.reverse[inrow];
                if (outrow != -1) {
                    this.fireTableRowsUpdated(outrow, outrow);
                }
                ++inrow;
            }
        }
    }
}

