/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.table;

import ca.nanometrics.uitools.table.TableNode;
import ca.nanometrics.uitools.table.TableSorter;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public class NmxTable
extends JTable
implements DropTargetListener,
DragGestureListener {
    private DragSource dragSource;
    private DropTarget dropTarget = new DropTarget(this, this);

    public NmxTable(TableSorter sorter) {
        super(sorter);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.addMouseListener(new TableMouseListener());
    }

    public NmxTable() {
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.addMouseListener(new TableMouseListener());
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        TableNode node = this.getNodeAtPoint(dtde.getLocation());
        if (node != null) {
            node.dragEnter(dtde);
        }
    }

    public void dragExit(DropTargetEvent dte) {
        Object obj = dte.getSource();
        if (obj instanceof TableNode) {
            TableNode node = (TableNode)obj;
            node.dragExit(dte);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        TableNode node = this.getNodeAtPoint(dge.getDragOrigin());
        if (node != null) {
            node.dragGestureRecognized(dge);
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        TableNode node = this.getNodeAtPoint(dtde.getLocation());
        if (node != null) {
            node.dragEnter(dtde);
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        TableNode node = this.getNodeAtPoint(dtde.getLocation());
        if (node != null) {
            node.drop(dtde);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        TableNode node = this.getNodeAtPoint(dtde.getLocation());
        if (node != null) {
            node.dropActionChanged(dtde);
        }
    }

    protected TableNode getNodeAtPoint(Point p) {
        int col;
        int row = this.rowAtPoint(p);
        Object obj = this.getValueAt(row, col = this.columnAtPoint(p));
        if (obj instanceof TableNode) {
            return (TableNode)obj;
        }
        return null;
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TableNode node = NmxTable.this.getNodeAtPoint(e.getPoint());
            if (node != null) {
                int buttonNo = e.getButton();
                if (buttonNo == 3 && e.getClickCount() == 1) {
                    node.rightClick(NmxTable.this, e.getX(), e.getY());
                } else if (buttonNo == 1) {
                    if (e.getClickCount() == 1) {
                        node.leftClick();
                    } else if (e.getClickCount() == 2) {
                        node.doubleLeftClick();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }
    }
}

