/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.table;

import ca.nanometrics.uitools.table.TableRow;
import ca.nanometrics.uitools.table.VectorTableModel;
import ca.nanometrics.util.HierarchalObservable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class NodeTableModel
extends VectorTableModel
implements Observer {
    private void removeAllRows() {
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            this.removeObserver((HierarchalObservable)iter.next());
        }
        this.rows.removeAllElements();
    }

    public void setRows(Vector rowVector) {
        this.removeAllRows();
        Enumeration e = rowVector.elements();
        while (e.hasMoreElements()) {
            Object row = e.nextElement();
            if (!(row instanceof HierarchalObservable) || !(row instanceof TableRow)) continue;
            this.addRow((TableRow)row);
        }
        this.fireTableDataChanged();
    }

    public void addRow(TableRow row) {
        if (row == null) {
            return;
        }
        if (row instanceof HierarchalObservable) {
            HierarchalObservable hO = (HierarchalObservable)((Object)row);
            hO.addObserver(this);
            this.rows.addElement(row);
        }
        this.fireTableDataChanged();
    }

    public void removeRow(TableRow row) {
        if (row instanceof HierarchalObservable) {
            HierarchalObservable hO = (HierarchalObservable)((Object)row);
            hO.deleteObserver(this);
        }
        this.rows.remove(row);
        this.fireTableDataChanged();
    }

    public void update(Observable o, Object arg) {
        this.fireTableDataChanged();
    }

    private void removeObserver(HierarchalObservable obj) {
        obj.deleteObserver(this);
    }
}

