/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.table;

import ca.nanometrics.uitools.table.IndexedTableMap;
import ca.nanometrics.uitools.table.TableSorterSettings;
import ca.nanometrics.util.Numeric;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends IndexedTableMap {
    private int sortColumn = 0;
    protected boolean ascending = true;
    private TableSorterSettings settings = new TableSorterSettings();

    public TableSorter() {
    }

    public TableSorter(TableModel model) {
        this.setModel(model);
    }

    private int compareVals(double d1, double d2) {
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    protected int compareRowsByColumn(int row1, int row2, int column) {
        Object obj1 = this.model.getValueAt(row1, column);
        Object obj2 = this.model.getValueAt(row2, column);
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        try {
            if (obj1 instanceof Number && obj2 instanceof Number) {
                Number n1 = (Number)obj1;
                Number n2 = (Number)obj2;
                return this.compareVals(n1.doubleValue(), n2.doubleValue());
            }
            if (obj1 instanceof Numeric && obj2 instanceof Numeric) {
                Numeric n1 = (Numeric)obj1;
                Numeric n2 = (Numeric)obj2;
                return this.compareVals(n1.doubleValue(), n2.doubleValue());
            }
            if (obj1 instanceof Comparable && obj2 instanceof Comparable) {
                Comparable c1 = (Comparable)obj1;
                Comparable c2 = (Comparable)obj2;
                int result = c1.compareTo(c2);
                return this.compareVals(result, 0.0);
            }
        }
        catch (ClassCastException c1) {
            // empty catch block
        }
        String s1 = obj1.toString();
        String s2 = obj2.toString();
        int result = s1.compareTo(s2);
        return this.compareVals(result, 0.0);
    }

    public int compare(int row1, int row2) {
        int result = this.compareRowsByColumn(row1, row2, this.sortColumn);
        if (result != 0) {
            return this.ascending ? result : -result;
        }
        return 0;
    }

    protected void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i = low;
            while (i < high) {
                to[i] = from[i];
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    protected void sort() {
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    protected void updateForwardMap() {
        int rowCount = this.model.getRowCount();
        if (rowCount != this.indexes.length) {
            this.indexes = new int[rowCount];
            int row = 0;
            while (row < rowCount) {
                this.indexes[row] = row;
                ++row;
            }
        }
        if (this.sortColumn >= 0 && this.sortColumn < this.model.getColumnCount()) {
            this.sort();
        }
    }

    public void sortByColumn(int column, boolean ifAscending) {
        this.settings.setColumn(column);
        this.settings.setAscending(ifAscending);
        this.sortColumn = column;
        this.ascending = ifAscending;
        this.remap();
    }

    public void applySettings(TableSorterSettings newSettings) {
        if (newSettings != null) {
            this.settings = newSettings;
            this.sortByColumn(this.settings.getColumn(), this.settings.isAscending());
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        table.setColumnSelectionAllowed(false);
        JTableHeader th = table.getTableHeader();
        th.addMouseListener(new MouseHandler(table));
    }

    class MouseHandler
    extends MouseAdapter {
        private int clickColumn = 0;
        private JTable table = null;

        public MouseHandler(JTable theTable) {
            this.table = theTable;
        }

        private int getEventColumn(MouseEvent e) {
            int leftButton = e.getModifiers() & 0x10;
            if (leftButton != 0) {
                TableColumnModel columnModel = this.table.getColumnModel();
                return columnModel.getColumnIndexAtX(e.getX());
            }
            return -1;
        }

        public void mousePressed(MouseEvent e) {
            this.clickColumn = this.getEventColumn(e);
        }

        public void mouseReleased(MouseEvent e) {
            int column;
            if (this.clickColumn >= 0 && this.clickColumn == this.getEventColumn(e) && (column = this.table.convertColumnIndexToModel(this.clickColumn)) >= 0) {
                TableSorter.this.sortByColumn(column, !TableSorter.this.ascending);
            }
        }
    }
}

