/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.tree;

import ca.nanometrics.uitools.tree.NmxDnDSourceSingleton;
import ca.nanometrics.uitools.tree.NmxDragDropEvent;
import ca.nanometrics.uitools.tree.NmxTreeCellEditor;
import ca.nanometrics.uitools.tree.NmxTreeCellRenderer;
import ca.nanometrics.uitools.tree.NmxTreeModelListener;
import ca.nanometrics.uitools.tree.NmxTreeNode;
import ca.nanometrics.uitools.tree.NmxTreeNodeMouseAdapter;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.CellEditor;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NmxTree
extends JTree
implements DropTargetListener,
DragGestureListener,
TreeWillExpandListener {
    private DropTarget dropTarget = new DropTarget(this, 3, this);
    private DragSource dragSource = new DragSource();

    public NmxTree(NmxTreeNode topNode) {
        this(new DefaultTreeModel(topNode));
        topNode.setModel((DefaultTreeModel)this.getModel());
        topNode.setTree(this);
    }

    public NmxTree(TreeModel newModel) {
        super(newModel);
        newModel.addTreeModelListener(new NmxTreeModelListener(this));
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new NmxTreeCellRenderer());
        this.addMouseListener(new NmxTreeNodeMouseAdapter(this));
        this.addTreeWillExpandListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        NmxTreeCellEditor cellEditor = new NmxTreeCellEditor(this, (NmxTreeCellRenderer)this.getCellRenderer());
        cellEditor.addCellEditorListener(new NmxCellEditorListener());
        this.setCellEditor(cellEditor);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public boolean isPathEditable(TreePath path) {
        if (!this.isEditable()) {
            return false;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof NmxTreeNode)) {
            return false;
        }
        NmxTreeNode aTreeNode = (NmxTreeNode)lastPathComponent;
        return aTreeNode.isNodeEditable();
    }

    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        NmxTreeNode node = (NmxTreeNode)path.getLastPathComponent();
        node.onExpand();
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (this.acceptRejectDragEvent(new NmxDragDropEvent(event)) == null) {
            event.rejectDrag();
        }
    }

    private NmxTreeNode acceptRejectDragEvent(NmxDragDropEvent event) {
        TreePath path = this.getPathForLocation(event.getMouseX(), event.getMouseY());
        Object[] pathList = new Object[]{this.getModel().getRoot()};
        if (path != null) {
            pathList = path.getPath();
        }
        if (pathList.length > 0 && pathList[pathList.length - 1] == NmxDnDSourceSingleton.getDragSource()) {
            return null;
        }
        int index = pathList.length - 1;
        while (index >= 0) {
            if (pathList[index] instanceof NmxTreeNode) {
                NmxTreeNode node = (NmxTreeNode)pathList[index];
                node.acceptRejectDragEvent(pathList, index, event);
                if (event.isAccepted()) {
                    return node;
                }
            }
            --index;
        }
        return null;
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
        if (this.acceptRejectDragEvent(new NmxDragDropEvent(event)) == null) {
            event.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent event) {
        NmxTreeNode node = this.acceptRejectDragEvent(new NmxDragDropEvent(event));
        if (node == null) {
            event.rejectDrop();
            return;
        }
        TreePath path = this.getPathForLocation(event.getLocation().x, event.getLocation().y);
        Object[] pathList = null;
        if (path != null) {
            pathList = path.getPath();
        }
        NmxDnDSourceSingleton.setDragTarget(node);
        node.drop(pathList, event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        if (this.acceptRejectDragEvent(new NmxDragDropEvent(event)) == null) {
            event.rejectDrag();
        }
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        TreePath path = this.getPathForLocation(event.getDragOrigin().x, event.getDragOrigin().y);
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null || !(obj instanceof NmxTreeNode)) {
            return;
        }
        ((NmxTreeNode)obj).startDrag(event);
    }

    public void dispose() {
        this.dropTarget.setComponent(null);
        this.dropTarget.removeDropTargetListener(this);
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.dropTarget = null;
        this.dragSource = null;
    }

    public void startEditingAtPath(TreePath path) {
        Object lastPathComponent = path.getLastPathComponent();
        Object oldUserObject = null;
        NmxTreeNode nmxNode = null;
        if (lastPathComponent instanceof NmxTreeNode) {
            nmxNode = (NmxTreeNode)lastPathComponent;
            oldUserObject = nmxNode.getUserObject();
            nmxNode.setUserObject(nmxNode.getEditString());
        }
        this.collapsePath(path);
        super.startEditingAtPath(path);
        if (nmxNode != null) {
            nmxNode.setUserObject(oldUserObject);
        }
    }

    class NmxCellEditorListener
    implements CellEditorListener {
        NmxCellEditorListener() {
        }

        public void editingStopped(ChangeEvent e) {
            CellEditor cell;
            if (e.getSource() instanceof CellEditor && (cell = (CellEditor)e.getSource()).getCellEditorValue() instanceof String) {
                String cellValue = (String)cell.getCellEditorValue();
                if (NmxTree.this.getEditingPath() != null && NmxTree.this.getEditingPath().getLastPathComponent() instanceof NmxTreeNode) {
                    NmxTreeNode filterNode = (NmxTreeNode)NmxTree.this.getEditingPath().getLastPathComponent();
                    filterNode.cellEdit(cellValue);
                    cell.cancelCellEditing();
                }
            }
        }

        public void editingCanceled(ChangeEvent e) {
        }
    }
}

