/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.uitools.tree;

import ca.nanometrics.uitools.tree.NmxTreeNode;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class NmxTreeNodeMouseAdapter
extends MouseAdapter {
    private JTree tree;

    public NmxTreeNodeMouseAdapter(JTree tree) {
        this.tree = tree;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.allowNodeToProcessEvent(e)) {
            return;
        }
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1 && (e.getModifiers() & 4) != 0) {
            if (!this.tree.isRowSelected(selRow)) {
                this.tree.setSelectionRow(selRow);
            }
            if (selPath.getLastPathComponent() instanceof NmxTreeNode) {
                NmxTreeNode node = (NmxTreeNode)selPath.getLastPathComponent();
                node.rightClick(this.tree, e.getX(), e.getY());
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.allowNodeToProcessEvent(e);
    }

    private boolean allowNodeToProcessEvent(MouseEvent e) {
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null && selPath.getLastPathComponent() instanceof NmxTreeNode) {
            Rectangle bounds = this.tree.getPathBounds(selPath);
            return ((NmxTreeNode)selPath.getLastPathComponent()).processMouseEvent(e, bounds);
        }
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.allowNodeToProcessEvent(e)) {
            return;
        }
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            if (e.getClickCount() == 2) {
                if (selPath.getLastPathComponent() instanceof NmxTreeNode) {
                    NmxTreeNode node = (NmxTreeNode)selPath.getLastPathComponent();
                    this.tree.setCursor(Cursor.getPredefinedCursor(3));
                    node.doubleLeftClick();
                    this.tree.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else if (e.getClickCount() == 1 && selPath.getLastPathComponent() instanceof NmxTreeNode) {
                NmxTreeNode node = (NmxTreeNode)selPath.getLastPathComponent();
                node.leftClick();
            }
        }
    }
}

