/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.BinarySearchTreeNode;

public class AVLNode
extends BinarySearchTreeNode {
    private int m_height = 0;

    public AVLNode(Comparable key, BinarySearchTreeNode parent) {
        super(key, parent);
        this.balance();
    }

    public void balance() {
        this.adjustHeight();
        if (Math.abs(this.getBalanceFactor()) > 1) {
            if (this.getBalanceFactor() > 0) {
                if (this.getLeftAVL().getBalanceFactor() > 0) {
                    this.doLLRotation();
                } else {
                    this.doLRRotation();
                }
            } else if (this.getRightAVL().getBalanceFactor() < 0) {
                this.doRRRotation();
            } else {
                this.doRLRotation();
            }
        }
        if (this.getParentAVL() != null) {
            this.getParentAVL().balance();
        }
    }

    public void dispose() {
        AVLNode parent = this.getParentAVL();
        super.dispose();
        if (parent != null) {
            parent.balance();
        }
    }

    public AVLNode getLeftAVL() {
        return (AVLNode)this.getLeft();
    }

    public AVLNode getParentAVL() {
        return (AVLNode)this.getParent();
    }

    public AVLNode getRightAVL() {
        return (AVLNode)this.getRight();
    }

    private void adjustHeight() {
        int height = Math.max(this.getLeft() != null ? this.getLeftAVL().getHeight() : -1, this.getRight() != null ? this.getRightAVL().getHeight() : -1) + 1;
        if (height != this.getHeight()) {
            this.m_height = height;
        }
    }

    private void doLLRotation() {
        AVLNode temp = this.getRightAVL();
        this.setRight(this.getLeft());
        this.setLeft(this.getRight().getLeft());
        this.getRight().setLeft(this.getRight().getRight());
        this.getRight().setRight(temp);
        this.swapKeys(this.getRight());
        this.getRightAVL().adjustHeight();
        this.adjustHeight();
    }

    private void doLRRotation() {
        if (this.getLeftAVL() != null) {
            this.getLeftAVL().doRRRotation();
        }
        this.doLLRotation();
    }

    private void doRLRotation() {
        if (this.getRightAVL() != null) {
            this.getRightAVL().doLLRotation();
        }
        this.doRRRotation();
    }

    private void doRRRotation() {
        AVLNode temp = this.getLeftAVL();
        this.setLeft(this.getRight());
        this.setRight(this.getLeft().getRight());
        this.getLeft().setRight(this.getLeft().getLeft());
        this.getLeft().setLeft(temp);
        this.swapKeys(this.getLeft());
        this.getLeftAVL().adjustHeight();
        this.adjustHeight();
    }

    private int getBalanceFactor() {
        int factor = 0;
        if (this.getLeftAVL() != null) {
            factor += this.getLeftAVL().getHeight() + 1;
        }
        if (this.getRightAVL() != null) {
            factor -= this.getRightAVL().getHeight() + 1;
        }
        return factor;
    }

    private int getHeight() {
        return this.m_height;
    }
}

