/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.LittleEndian;
import java.io.DataInput;
import java.io.IOException;

public class LittleEndianDataInput
implements DataInput {
    private DataInput input;

    public LittleEndianDataInput(DataInput source) {
        this.input = source;
    }

    public int skipBytes(int n) throws IOException {
        return this.input.skipBytes(n);
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public int readUnsignedByte() throws IOException {
        return this.input.readUnsignedByte();
    }

    public String readUTF() throws IOException {
        return this.input.readUTF();
    }

    public String readLine() throws IOException {
        return this.input.readLine();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.input.readFully(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.input.readFully(b);
    }

    public char readChar() throws IOException {
        return this.input.readChar();
    }

    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    private byte[] getBytes(int num) throws IOException {
        byte[] buff = new byte[num];
        this.input.readFully(buff);
        return buff;
    }

    public short readShort() throws IOException {
        return LittleEndian.readShort(this.getBytes(2), 0);
    }

    public int readInt() throws IOException {
        return LittleEndian.readInt(this.getBytes(4), 0);
    }

    public long readLong() throws IOException {
        return LittleEndian.readLong(this.getBytes(8), 0);
    }

    public float readFloat() throws IOException {
        return LittleEndian.readFloat(this.getBytes(4), 0);
    }

    public double readDouble() throws IOException {
        return LittleEndian.readDouble(this.getBytes(8), 0);
    }

    public boolean isForwardOrder() {
        return false;
    }
}

