/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Debugger;
import ca.nanometrics.util.ErrorLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class Log {
    public static final int DEBUG = 0;
    public static final int VERBOSE = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static final int UNKNOWN = 6;
    public static final char[] severityLabel = new char[]{'D', 'V', 'I', 'W', 'E', 'F', 'X'};
    public static final String[] verbosityName = new String[]{"DEBUG", "VERBOSE", "INFO", "WARNING", "ERROR", "FATAL"};
    private static ErrorLog log = null;
    private static Debugger debugger = null;

    public static boolean isDebug() {
        return Log.isOn(0);
    }

    public static boolean isVerbose() {
        return Log.isOn(1);
    }

    public static boolean isInfo() {
        return Log.isOn(2);
    }

    public static boolean isWarning() {
        return Log.isOn(3);
    }

    public static boolean isError() {
        return Log.isOn(4);
    }

    public static boolean isFatal() {
        return Log.isOn(5);
    }

    public static boolean isOn(int level) {
        return log != null ? log.getVerbosity() <= level : false;
    }

    public static void debug(String name, int errNum, String message) {
        if (Log.isOn(0)) {
            log.report(name, errNum, 0, message);
        }
    }

    public static void verbose(String name, int errNum, String message) {
        if (Log.isOn(1)) {
            log.report(name, errNum, 1, message);
        }
    }

    public static void info(String name, int errNum, String message) {
        if (Log.isOn(2)) {
            log.report(name, errNum, 2, message);
        }
    }

    public static void warning(String name, int errNum, String message) {
        if (Log.isOn(3)) {
            log.report(name, errNum, 3, message);
        }
    }

    public static void error(String name, int errNum, String message) {
        if (Log.isOn(4)) {
            log.report(name, errNum, 4, message);
        }
    }

    public static void error(String name, int errNum, String message, Throwable t) {
        Log.error(name, errNum, Log.appendStackTrace(message, t));
    }

    public static void fatal(String name, int errNum, String message) {
        if (Log.isOn(5)) {
            log.report(name, errNum, 5, message);
        }
    }

    public static void debug(Object obj, int errNum, String message) {
        if (Log.isOn(0)) {
            log.report(obj, errNum, 0, message);
        }
    }

    public static void verbose(Object obj, int errNum, String message) {
        if (Log.isOn(1)) {
            log.report(obj, errNum, 1, message);
        }
    }

    public static void info(Object obj, int errNum, String message) {
        if (Log.isOn(2)) {
            log.report(obj, errNum, 2, message);
        }
    }

    public static void warning(Object obj, int errNum, String message) {
        if (Log.isOn(3)) {
            log.report(obj, errNum, 3, message);
        }
    }

    public static void warning(String name, int errNum, String message, Throwable t) {
        Log.warning(name, errNum, Log.appendStackTrace(message, t));
    }

    public static void warning(Object obj, int errNum, String message, Throwable t) {
        Log.warning(obj, errNum, Log.appendStackTrace(message, t));
    }

    public static void error(Object obj, int errNum, String message) {
        if (Log.isOn(4)) {
            log.report(obj, errNum, 4, message);
        }
    }

    public static void error(Object obj, int errNum, String message, Throwable t) {
        Log.error(obj, errNum, Log.appendStackTrace(message, t));
    }

    public static String appendStackTrace(String message, Throwable t) {
        try {
            StringWriter strings = new StringWriter();
            strings.write("           ****EXCEPTION***exception--->    ");
            strings.write(message);
            strings.write(": ");
            PrintWriter writer = new PrintWriter(strings);
            t.printStackTrace(writer);
            StringTokenizer tokens = new StringTokenizer(strings.toString(), "\n");
            StringBuffer answer = new StringBuffer();
            while (tokens.hasMoreTokens()) {
                answer.append(tokens.nextToken().trim());
                answer.append(" & ");
            }
            return answer.toString();
        }
        catch (Exception e) {
            try {
                return "[Problem reporting error] " + message + " " + t;
            }
            catch (Exception e2) {
                return message;
            }
        }
    }

    public static void fatal(Object obj, int errNum, String message) {
        if (Log.isOn(5)) {
            log.report(obj, errNum, 5, message);
        }
    }

    public static void report(Object obj, int errNum, int severity, String message) {
        if (log != null) {
            log.report(obj, errNum, severity, message);
        }
    }

    public static void report(String name, int errNum, int severity, String message) {
        if (log != null) {
            log.report(name, errNum, severity, message);
        }
    }

    public static void report(int severity, long time, String source, String message) {
        if (log != null) {
            log.report(severity, time, source, message);
        }
    }

    public static void debug(Object obj, String message) {
        if (debugger != null) {
            debugger.report(obj, message);
        }
    }

    public static void debug(String message) {
        if (debugger != null) {
            debugger.report(message);
        }
    }

    public static int getVerbosity() {
        if (log != null) {
            return log.getVerbosity();
        }
        return 6;
    }

    public static void setVerbosity(int severity) {
        if (log != null) {
            log.setVerbosity(severity);
        }
    }

    public static int parseVerbosity(String verbosityString) {
        int i = 0;
        while (i < verbosityName.length) {
            if (verbosityString.toUpperCase().equals(verbosityName[i])) {
                return i;
            }
            ++i;
        }
        return 2;
    }

    public static void installLog(ErrorLog errorLog) {
        log = errorLog;
    }

    public static void installDebugConsole(Debugger aDebugger) {
        debugger = aDebugger;
    }
}

