/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.NmxDateFormat;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class SimpleParser {
    BufferedReader input;
    String nextLine = null;
    int lineCount = 0;
    String filename;

    public SimpleParser(String theFilename) throws FileNotFoundException {
        this.filename = theFilename;
        this.input = new BufferedReader(new FileReader(this.filename));
    }

    public int getLineCount() {
        return this.lineCount;
    }

    protected String readLine() throws IOException {
        String line;
        this.nextLine = null;
        do {
            if ((line = this.input.readLine()) == null) {
                return line;
            }
            ++this.lineCount;
            int comment = line.indexOf("//");
            if (comment < 0) continue;
            line = line.substring(0, comment);
        } while ((line = line.trim()).length() <= 0);
        return line;
    }

    public String getLine() throws IOException {
        if (this.nextLine != null) {
            String line = this.nextLine;
            this.nextLine = null;
            return line;
        }
        return this.readLine();
    }

    public String peekLine() {
        if (this.nextLine == null) {
            try {
                this.nextLine = this.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.nextLine;
    }

    private static boolean isHeader(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    private static String getLabelOf(String line) {
        if (SimpleParser.isHeader(line)) {
            line = line.substring(line.indexOf(91) + 1, line.lastIndexOf(93));
            return line.trim();
        }
        int separator = line.indexOf("=");
        if (separator >= 0) {
            line = line.substring(0, separator);
        }
        return line.trim();
    }

    public boolean isNextLineHeader() {
        this.peekLine();
        return this.nextLine != null && SimpleParser.isHeader(this.nextLine);
    }

    public boolean isNextLineHeader(String label) {
        return this.isNextLineHeader() && SimpleParser.getLabelOf(this.nextLine).equals(label);
    }

    public boolean isNextLineParam() {
        this.peekLine();
        return this.nextLine != null && !SimpleParser.isHeader(this.nextLine);
    }

    public boolean isNextLineParam(String label) {
        return this.isNextLineParam() && SimpleParser.getLabelOf(this.nextLine).equals(label);
    }

    public String peekLabel() {
        this.peekLine();
        if (this.nextLine != null) {
            return SimpleParser.getLabelOf(this.nextLine);
        }
        return null;
    }

    public String getHeader() throws IOException {
        String line = this.getLine();
        if (line == null) {
            return line;
        }
        if (SimpleParser.isHeader(line)) {
            return SimpleParser.getLabelOf(line);
        }
        throw this.IOX("Expected section header, got " + line);
    }

    public String getHeader(String name) throws IOException {
        String header = this.getHeader();
        if (header == null) {
            throw this.IOX("EOF reading section " + name);
        }
        if (!header.equals(name)) {
            throw this.IOX("Expected " + name + ", got " + header);
        }
        return header;
    }

    public String readString(String prefix) throws IOException {
        String line = this.getLine();
        if (line == null) {
            throw this.IOX("EOF reading " + prefix);
        }
        if (SimpleParser.isHeader(line)) {
            throw this.IOX("Expected " + prefix + ", got " + line);
        }
        int separator = line.indexOf("=");
        if (separator < 0) {
            throw this.IOX("Missing \"=\" sign");
        }
        if (separator < 1) {
            throw this.IOX("Missing identifier");
        }
        String name = line.substring(0, separator);
        if (!(name = name.trim()).equals(prefix)) {
            throw this.IOX("Expected " + prefix + ", got " + line);
        }
        String value = line.substring(separator + 1, line.length());
        if ((value = value.trim()).length() < 1) {
            throw this.IOX("Missing value in " + line);
        }
        return value;
    }

    public int readInt(String prefix) throws IOException {
        String line = this.readString(prefix);
        try {
            return Integer.parseInt(line);
        }
        catch (Exception e) {
            throw this.IOX("Integer format error");
        }
    }

    public double readDouble(String prefix) throws IOException {
        String line = this.readString(prefix);
        try {
            Double temp = new Double(line);
            return temp;
        }
        catch (Exception e) {
            throw this.IOX("Floating point format error");
        }
    }

    public long readDateTime(String prefix) throws IOException {
        String line = this.readString(prefix);
        try {
            long time = NmxDateFormat.parseDate(line).getTime();
            return time;
        }
        catch (Exception e) {
            throw this.IOX("Date format error");
        }
    }

    public int[] readIntArray(String prefix) throws IOException {
        String line = this.readString(prefix);
        try {
            StringTokenizer st = new StringTokenizer(line, ",");
            int numVals = st.countTokens();
            int[] values = new int[numVals];
            int ix = 0;
            while (ix < numVals) {
                values[ix] = Integer.parseInt(st.nextToken().trim());
                ++ix;
            }
            return values;
        }
        catch (Exception e) {
            throw this.IOX("Integer format error");
        }
    }

    public IOException IOX(String message) {
        return new IOException(String.valueOf(message) + " at line " + this.lineCount + " of " + this.filename);
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

