/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.util.NoSuchElementException;

public class StrictTokenizer {
    private String text;
    private String separators;
    private int offset;

    public StrictTokenizer(String textToParse, String delimiters) {
        this.text = textToParse;
        this.separators = delimiters;
        if (this.separators == null) {
            this.separators = ",";
        }
        this.offset = 0;
    }

    private boolean isSeparator(int achar) {
        return this.separators.indexOf(achar) >= 0;
    }

    public int countTokens() {
        int length = this.text.length();
        if (this.offset > length) {
            return 0;
        }
        int count = 1;
        int ix = this.offset;
        while (ix < length) {
            if (this.isSeparator(this.text.charAt(ix))) {
                ++count;
            }
            ++ix;
        }
        return count;
    }

    public boolean hasMoreTokens() {
        return this.offset <= this.text.length();
    }

    private int nextSeparator() {
        int length = this.text.length();
        int ix = this.offset;
        while (ix < length) {
            if (this.isSeparator(this.text.charAt(ix))) {
                return ix;
            }
            ++ix;
        }
        return length;
    }

    public String nextToken() {
        int length = this.text.length();
        if (this.offset > length) {
            throw new NoSuchElementException("StrictTokenizer");
        }
        if (this.offset == length) {
            ++this.offset;
            return "";
        }
        int next = this.nextSeparator();
        String token = this.text.substring(this.offset, next);
        this.offset = next + 1;
        return token;
    }
}

