/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;

public class StringHelper {
    private StringHelper() {
    }

    public static String padToFixedLength(String string, int lengthToPadTo, char charToPadWith) {
        StringBuffer stringIn = new StringBuffer(string);
        if (stringIn.length() < lengthToPadTo) {
            int i = stringIn.length();
            while (i < lengthToPadTo) {
                stringIn = stringIn.append(charToPadWith);
                ++i;
            }
        }
        return stringIn.toString();
    }

    public static String padStartToLength(String string, int lengthToPadTo, char charToPadWith) {
        StringBuffer stringIn = new StringBuffer(string);
        if (stringIn.length() < lengthToPadTo) {
            int i = stringIn.length();
            while (i < lengthToPadTo) {
                stringIn.insert(0, charToPadWith);
                ++i;
            }
        }
        return stringIn.toString();
    }

    public static String toFixedLength(String s, int length) {
        String fixed = new String(s);
        fixed = fixed.length() > length ? s.substring(0, length) : StringHelper.padStartToLength(fixed, length, ' ');
        return fixed;
    }

    public static int getLonger(String string1, String string2) {
        return Math.max(string1.length(), string2.length());
    }

    public static int getLongest(List strings) {
        Iterator iter = strings.iterator();
        int maxSize = 0;
        while (iter.hasNext()) {
            String string = (String)iter.next();
            if (string.length() <= maxSize) continue;
            maxSize = string.length();
        }
        return maxSize;
    }

    public static String stringRepeatingChar(char charIn, int num) {
        StringBuffer repeatingString = new StringBuffer(charIn);
        int i = 1;
        while (i < num) {
            repeatingString.append(charIn);
            ++i;
        }
        return repeatingString.toString();
    }

    public static String expFormat(double d, int decimals) {
        String pattern = String.valueOf(StringHelper.padToFixedLength("0.", decimals + 2, '0')) + "E00";
        NumberFormat nf = NumberFormat.getInstance();
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).applyPattern(pattern);
        }
        String s = nf.format(d);
        if (Math.abs(d) >= 1.0) {
            s = String.valueOf(s) + " ";
        }
        return nf.format(d);
    }

    public static String expFixedFormat(double d, int numChars, int decimals) {
        String s = StringHelper.expFormat(d, decimals);
        s = StringHelper.padStartToLength(s, numChars, ' ');
        return s;
    }

    public static String floatFormat(double d, int decimals) {
        String pattern = StringHelper.padToFixedLength("0.", decimals + 2, '0');
        pattern = " " + pattern + ";-" + pattern;
        NumberFormat nf = NumberFormat.getInstance();
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).applyPattern(pattern);
        }
        String s = nf.format(d);
        if (d < 1.0) {
            s = String.valueOf(s) + " ";
        }
        return nf.format(d);
    }

    public static String floatFixedFormat(double d, int numChars, int decimals) {
        String s = StringHelper.floatFormat(d, decimals);
        s = StringHelper.padStartToLength(s, numChars, ' ');
        return s;
    }

    public static String sigFigsFormat(double d, int numSigFigs) {
        String s;
        double absVal = Math.abs(d);
        if (absVal < 10.0 && absVal >= 1.0) {
            s = StringHelper.floatFormat(d, numSigFigs - 1);
            s = String.valueOf(s) + "     ";
        } else if (absVal < 1.0 && absVal >= 0.1 || absVal == 0.0) {
            s = StringHelper.floatFormat(d, numSigFigs);
            s = String.valueOf(s) + "    ";
        } else {
            s = StringHelper.expFormat(d, numSigFigs - 1);
        }
        return s;
    }
}

