/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.vmodel;

import ca.nanometrics.vmodel.DoubleModel;
import ca.nanometrics.vmodel.ValueListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class DoubleModelTextField
extends JTextField
implements ValueListener {
    protected DoubleModel model;

    public DoubleModelTextField(DoubleModel amodel) {
        this.model = amodel;
        if (this.model == null) {
            throw new IllegalArgumentException("null model in DoubleModelTextField");
        }
        this.model.addValueListener(this);
        this.addKeyListener(new KeyMonitor());
        this.addFocusListener(new FocusMonitor());
    }

    public DoubleModelTextField(DoubleModel amodel, int columns) {
        this(amodel);
        this.setColumns(columns);
    }

    public void valueChanged(Object source) {
        double val = this.model.getValue();
        super.setText(this.convertValueToText(val));
    }

    public void setValue(double val) {
        if (!this.model.setValue(val)) {
            this.valueChanged(this.model);
        }
    }

    public void setText(String text) {
        if (!this.model.setValue(text)) {
            this.valueChanged(this.model);
        }
    }

    public String convertValueToText(double val) {
        return "" + val;
    }

    public void update() {
        String text = this.getText();
        this.setText(text);
    }

    public void dispose() {
        this.model.removeValueListener(this);
    }

    class FocusMonitor
    implements FocusListener {
        FocusMonitor() {
        }

        public void focusLost(FocusEvent e) {
            DoubleModelTextField.this.update();
        }

        public void focusGained(FocusEvent e) {
        }
    }

    class KeyMonitor
    implements KeyListener {
        KeyMonitor() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                DoubleModelTextField.this.update();
            }
            if (e.getKeyCode() == 27) {
                DoubleModelTextField.this.valueChanged(DoubleModelTextField.this.model);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

