/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.vmodel;

import ca.nanometrics.vmodel.IntegerModel;
import ca.nanometrics.vmodel.ValueListener;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class IntegerModelTextField
extends JTextField
implements ValueListener {
    protected IntegerModel model;
    private int columns;

    public IntegerModelTextField(IntegerModel amodel) {
        this.model = amodel;
        if (this.model == null) {
            throw new IllegalArgumentException("null model in IntegerModelTextField");
        }
        this.model.addValueListener(this);
        this.addKeyListener(new KeyMonitor());
        this.addFocusListener(new FocusMonitor());
    }

    public IntegerModelTextField(IntegerModel amodel, int numColumns) {
        this(amodel);
        this.setColumns(numColumns);
    }

    public void setColumns(int numColumns) {
        this.columns = numColumns;
    }

    protected int charWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return fm.stringWidth("9");
    }

    public Dimension getMinimumSize() {
        Dimension mins = super.getMinimumSize();
        if (this.columns > 0) {
            Insets insets = this.getInsets();
            mins.width = insets.left + insets.right + this.columns * this.charWidth();
        }
        return mins;
    }

    public Dimension getPreferredSize() {
        Dimension mins = super.getPreferredSize();
        if (this.columns > 0) {
            Insets insets = this.getInsets();
            mins.width = insets.left + insets.right + (this.columns + 1) * this.charWidth();
        }
        return mins;
    }

    public void valueChanged(Object source) {
        int val = this.model.getValue();
        super.setText(this.convertValueToText(val));
    }

    public void setValue(int val) {
        if (!this.model.setValue(val)) {
            this.valueChanged(this.model);
        }
    }

    public void setText(String text) {
        if (!this.model.setValue(text)) {
            this.valueChanged(this.model);
        }
    }

    public String convertValueToText(int val) {
        return "" + val;
    }

    public void update() {
        String text = this.getText();
        this.setText(text);
    }

    public void dispose() {
        this.model.removeValueListener(this);
    }

    class FocusMonitor
    implements FocusListener {
        FocusMonitor() {
        }

        public void focusLost(FocusEvent e) {
            IntegerModelTextField.this.update();
        }

        public void focusGained(FocusEvent e) {
        }
    }

    class KeyMonitor
    implements KeyListener {
        KeyMonitor() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                IntegerModelTextField.this.update();
            }
            if (e.getKeyCode() == 27) {
                IntegerModelTextField.this.valueChanged(IntegerModelTextField.this.model);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

